/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io.aux;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.nio.charset.Charset;
import lombok.NonNull;
import org.grade.io.aux.Table;

public class Csv {
    @JsonProperty
    private char delimiter = (char)44;
    @JsonProperty
    @NonNull
    private String encoding = Charset.defaultCharset().name();
    @JsonProperty
    private char quote = (char)34;

    public Table asTable(InputStream stream) {
        return new Table(this, stream);
    }

    public char delimiter() {
        return this.delimiter;
    }

    @NonNull
    public String encoding() {
        return this.encoding;
    }

    public char quote() {
        return this.quote;
    }

    public Csv delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Csv encoding(@NonNull String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.encoding = encoding;
        return this;
    }

    public Csv quote(char quote) {
        this.quote = quote;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Csv)) {
            return false;
        }
        Csv other = (Csv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.delimiter() != other.delimiter()) {
            return false;
        }
        String this$encoding = this.encoding();
        String other$encoding = other.encoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        return this.quote() == other.quote();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Csv;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.delimiter();
        String $encoding = this.encoding();
        result = result * 59 + ($encoding == null ? 0 : $encoding.hashCode());
        result = result * 59 + this.quote();
        return result;
    }

    public String toString() {
        return "Csv(delimiter=" + this.delimiter() + ", encoding=" + this.encoding() + ", quote=" + this.quote() + ")";
    }

    private Csv() {
    }

    public static Csv csv() {
        return new Csv();
    }

    private Csv(char delimiter, @NonNull String encoding, char quote) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.delimiter = delimiter;
        this.encoding = encoding;
        this.quote = quote;
    }

    public static Csv csv(char delimiter, @NonNull String encoding, char quote) {
        return new Csv(delimiter, encoding, quote);
    }
}

