/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsreader;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.InitReaderThread;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.MakeLocalThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocationWrapper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ReaderInitParams;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;

public class RSTEXTReader
extends RSReader {
    private static Logger log = Logger.getLogger(RSTEXTReader.class);
    RSLocationWrapper rs = null;

    public static RSTEXTReader getRSTEXTReader(RSLocator locator) throws Exception {
        try {
            return new RSTEXTReader(new RSLocationWrapper(locator));
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSXMLReader Throwing Exception", (Throwable)e);
            throw new Exception("Could not create RSXMLReader");
        }
    }

    public static RSTEXTReader[] getRSTEXTReader(ReaderInitParams[] params) {
        int i;
        InitReaderThread[] ts = new InitReaderThread[params.length];
        RSTEXTReader[] rs = new RSTEXTReader[params.length];
        for (i = 0; i < params.length; ++i) {
            ts[i] = new InitReaderThread(params[i], InitReaderThread.RSReaderEnum.TEXTReader);
            ts[i].start();
        }
        for (i = 0; i < params.length; ++i) {
            try {
                ts[i].join();
                rs[i] = (RSTEXTReader)ts[i].getReader();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"interrupted whil waiting for reader. setting to null");
                rs[i] = null;
            }
        }
        return rs;
    }

    protected RSTEXTReader(RSLocationWrapper rs) {
        super(rs);
        this.rs = rs;
    }

    @Override
    public RSTEXTReader makeLocal(RSResourceType type) throws Exception {
        try {
            if (this.isLocal()) {
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                    return RSTEXTReader.getRSTEXTReader(this.rs.getRSLocator());
                }
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceWSRFType) {
                    return RSTEXTReader.getRSTEXTReader(new RSLocator(new RSResourceLocalType(), this.rs.getHeadFileName()));
                }
                log.error((Object)"RSResource type not recognized. Throwing Exception");
                throw new Exception("RSResource type not recognized");
            }
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            String properties = thisReader.retrieveCustomProperties();
            RSFullWriter writer = RSFullWriter.getRSFullWriter(properties);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            return RSTEXTReader.getRSTEXTReader(writer.getRSLocator(type));
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    @Override
    public RSTEXTReader makeLocal(RSResourceType type, int count) throws Exception {
        if (count < 0) {
            log.error((Object)"invalid topCount argument. Throwing Exception");
            throw new Exception("invalid topCount argument");
        }
        try {
            return this.keepTop(count).makeLocal(type);
        }
        catch (Exception e) {
            log.error((Object)"could not perform partial localization. Throwing Exception", (Throwable)e);
            throw new Exception("could not perform partial localization");
        }
    }

    @Override
    public RSTEXTReader keepTop(int count, PropertyElementBase[] properties) throws Exception {
        try {
            return RSTEXTReader.getRSTEXTReader(super.keepTop(count, properties).getRSLocator());
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSTEXTReader keepTop(int count) throws Exception {
        try {
            return RSTEXTReader.getRSTEXTReader(super.keepTop(count).getRSLocator());
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSTEXTReader cloneRS() throws Exception {
        try {
            return RSTEXTReader.getRSTEXTReader(super.cloneRS().getRSLocator());
        }
        catch (Exception e) {
            log.error((Object)"Could not clone rs. Throwing Exception", (Throwable)e);
            throw new Exception("Could not clone rs");
        }
    }

    public String getFullPayload() throws Exception {
        try {
            return this.rs.getCurrentContentPartPayload();
        }
        catch (Exception e) {
            log.error((Object)"Could not get payload. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get payload");
        }
    }

    public int getNumberOfResults() throws Exception {
        try {
            return this.rs.getNumberOfResults(PropertyElementType.TEXT);
        }
        catch (Exception e) {
            log.error((Object)"Could not get number of results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get number of results");
        }
    }
}

