/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployer.server;

import java.util.List;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.EmailNotification;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.entity.ContextImpl;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.context.ResourceRegistryContextClientFactory;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewVRECreatedThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(NewVRECreatedThread.class);
    final String SUBJECT = "New VRE Created notification";
    private GroupManager gm;
    private String creatorUserName;
    private String creatorFullName;
    private String vreScope;
    private String vreName;
    private long currentScopeGroupId;

    public NewVRECreatedThread(String creatorUserName, String creatorFullName, String vreScope, String vreName, long currentScopeGroupId) {
        this.creatorUserName = creatorUserName;
        this.creatorFullName = creatorFullName;
        this.vreScope = vreScope;
        this.vreName = vreName;
        this.currentScopeGroupId = currentScopeGroupId;
        this.gm = new LiferayGroupManager();
    }

    @Override
    public void run() {
        this.handleVRECreatedNotificationEmail(this.creatorUserName, this.creatorFullName, this.vreScope);
        this.handleVRECreatedContextAddonResourceRegistry(this.vreScope, this.vreName, this.currentScopeGroupId);
    }

    private void handleVRECreatedContextAddonResourceRegistry(String vreScope, String vreName, long currentScopeGroupId) {
        try {
            GCubeGroup voGroup = this.gm.getGroup(currentScopeGroupId);
            String currentScope = this.gm.getInfrastructureScope(currentScopeGroupId);
            _log.debug("handleVRECreatedContextAddonResourceRegistry, VO Scope= " + currentScope);
            ScopeProvider.instance.set(currentScope);
            ResourceRegistryContextClient rrClient = ResourceRegistryContextClientFactory.create();
            ContextImpl context = new ContextImpl(vreName);
            List contexts = rrClient.all();
            Context parent = null;
            for (Context c : contexts) {
                if (c.getName().compareTo(voGroup.getGroupName()) != 0) continue;
                parent = c;
                break;
            }
            _log.debug("setting parent as= " + parent.getName());
            context.setParent(parent);
            _log.debug("creating context: " + context.toString());
            rrClient.create((Context)context);
            _log.debug("created context OK");
        }
        catch (Exception e) {
            _log.error("an error occurred wehn creating new context on Resource Registry", (Throwable)e);
        }
    }

    private void handleVRECreatedNotificationEmail(String newUserUserName, String newUserFullName, String vreScope) {
        LiferayUserManager um = new LiferayUserManager();
        LiferayRoleManager rm = new LiferayRoleManager();
        try {
            String rootVoName = PortalContext.getConfiguration().getInfrastructureName();
            long groupId = this.gm.getGroupIdFromInfrastructureScope("/" + rootVoName);
            long infraManagerRoleId = -1L;
            try {
                infraManagerRoleId = rm.getRoleIdByName(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            }
            catch (RoleRetrievalFault e) {
                _log.warn("There is no (Site) Role " + infraManagerRoleId + " in this portal. Will not notify about newly VRE creations.");
                return;
            }
            _log.trace("Root is: " + rootVoName + " Scanning roles ....");
            List managers = um.listUsersByGroupAndRole(groupId, infraManagerRoleId);
            if (managers == null || managers.isEmpty()) {
                _log.warn("There are no users with (Site) Role " + infraManagerRoleId + " on " + rootVoName + " in this portal.  Will not notify about newly VRE creations.");
            } else {
                for (GCubeUser manager : managers) {
                    this.sendNotification(manager, newUserUserName, newUserFullName, vreScope);
                    _log.info("sent email to manager: " + manager.getEmail());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendNotification(GCubeUser manager, String creatorUserName, String creaotrFullName, String vreScope) {
        EmailNotification toSend = new EmailNotification(manager.getEmail(), "New VRE Created notification", NewVRECreatedThread.getHTMLEmail((String)manager.getFirstName(), (String)creatorUserName, (String)creaotrFullName, (String)vreScope), null);
        toSend.sendEmail();
    }

    private static String getHTMLEmail(String userFirstName, String creatorUsername, String creatorFullName, String vreScope) {
        String sender = creatorFullName + " (" + creatorUsername + ") ";
        StringBuilder body = new StringBuilder();
        body.append("<body><br />").append("<div style=\"color:#000; font-size:13px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif;\">").append("Dear ").append(userFirstName).append(",").append("<p>").append(sender).append(" ").append("as VRE Manager allowed the creation of the following VRE: ").append(vreScope).append("</div><br />").append("<p>Please note: the actual deploy may have been triggered by another VRE Manager</p>").append("<p>You received this email because you are an Infrastructure Manager in this portal</p>").append("</div></p>").append("</body>");
        return body.toString();
    }
}

