package org.gcube.portlets.admin.software_upload_wizard.server.softwaremanagers.maven.is;

import java.util.List;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.admin.software_upload_wizard.server.aslmanagers.ASLSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.maven.IMavenRepositoryInfo;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.maven.MavenRepositoryInfo;
import org.slf4j.Logger;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class MavenRepositoryISClient implements IMavenRepositoryIS {

	@InjectLogger
	private Logger logger;

	private static final String RUNTIME_RESOURCE_NAME = "MavenRepository";

	private static final String REPOSITORY_ID_PROPERTY_NAME = "repositoryId";
	
	private static final String REPOSITORY_URL_ATTR_VALUE = "RepositoryUrl";
	private static final String REPOSITORY_NEXUSBROWSEURL_ATTR_VALUE = "NexusUrl";

	private ASLSessionManager aslSessionManager;

	@Inject
	public MavenRepositoryISClient(ASLSessionManager aslSessionManager) {
		this.aslSessionManager = aslSessionManager;
	}

	@Override
	public IMavenRepositoryInfo getMavenRepository(String id) throws Exception {

		ASLSession session = aslSessionManager.getASLSession();

		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery query = client
				.getQuery(GCUBERuntimeResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Name",
				RUNTIME_RESOURCE_NAME));
		String xPathQuery = "$result/Profile/AccessPoint/Properties/Property[Name='"
				+ REPOSITORY_ID_PROPERTY_NAME + "' and Value='" + id + "']";
		// String xPathQuery =
		// "exists($result/Profile/AccessPoint/Properties/Property[Name='"+REPOSITORY_ID_PROPERTY_NAME+"' and Value='"+id+"'])";
		// String xPathQuery =
		// "count($result/Profile/AccessPoint/Properties//Property[./Name='"+REPOSITORY_ID_PROPERTY_NAME+"' and ./Value='"+id+"']) >0";

		logger.trace("Sending XPath Query: " + xPathQuery);
		query.addGenericCondition(xPathQuery);


		List<GCUBERuntimeResource> resources = client.execute(query,
				getScope());

		if (resources.size() == 0) {
			throw new Exception("No maven repository resource with name "
					+ RUNTIME_RESOURCE_NAME + ", id \" " + id
					+ "\", with scope '" + getScope().toString() + "'.");
		}

		if (resources.size() > 1) {
			throw new Exception(
					"Found more than one Maven repository resource, unable to choose the right one.");
		}

		AccessPoint accessPoint = null;
		for (AccessPoint tmp : resources.get(0).getAccessPoints())
			if (tmp.getEntryname().equals(REPOSITORY_URL_ATTR_VALUE))
				accessPoint = tmp;

		if (accessPoint == null)
			throw new Exception(
					"Cannot find a valid access point within the retrieved Maven repository resource.");

		return new MavenRepositoryInfo(id, accessPoint.getEndpoint());
	}

	@Override
	public IMavenRepositoryInfo getNexusRepository(String id) throws Exception {
		ASLSession session = aslSessionManager.getASLSession();

		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBERuntimeResourceQuery query = client
				.getQuery(GCUBERuntimeResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Name",
				RUNTIME_RESOURCE_NAME));
		String xPathQuery = "$result/Profile/AccessPoint/Properties/Property[Name='"
				+ REPOSITORY_ID_PROPERTY_NAME + "' and Value='" + id + "']";
		// String xPathQuery =
		// "exists($result/Profile/AccessPoint/Properties/Property[Name='"+REPOSITORY_ID_PROPERTY_NAME+"' and Value='"+id+"'])";
		// String xPathQuery =
		// "count($result/Profile/AccessPoint/Properties//Property[./Name='"+REPOSITORY_ID_PROPERTY_NAME+"' and ./Value='"+id+"']) >0";

		logger.trace("Sending XPath Query: " + xPathQuery);
		query.addGenericCondition(xPathQuery);

		List<GCUBERuntimeResource> resources = client.execute(query,
				getScope());

		if (resources.size() == 0) {
			throw new Exception("No maven repository resource with name "
					+ RUNTIME_RESOURCE_NAME + ", id \" " + id
					+ "\", with scope '" + getScope().toString() + "'.");
		}

		if (resources.size() > 1) {
			throw new Exception(
					"Found more than one Maven repository resource, unable to choose the right one.");
		}

		AccessPoint accessPoint = null;
		for (AccessPoint tmp : resources.get(0).getAccessPoints())
			if (tmp.getEntryname().equals(REPOSITORY_NEXUSBROWSEURL_ATTR_VALUE))
				accessPoint = tmp;

		if (accessPoint == null)
			throw new Exception(
					"Cannot find a valid access point within the retrieved Maven repository resource.");

		return new MavenRepositoryInfo(id, accessPoint.getEndpoint());
	}
	
	/**
	 * Return a valid scope for queries 
	 * @return The valid scope
	 */
	private GCUBEScope getScope(){
		ASLSession session = aslSessionManager.getASLSession();
		
		String scopeString = "/" + session.getScope().getInfrastructure().getName();
		
		return GCUBEScope.getScope(scopeString);
	}

}
