package org.gcube.portlets.admin.software_upload_wizard.server.logging.log4j;

import java.lang.reflect.Field;

import org.apache.log4j.Logger;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;

public class Log4JTypeListener implements TypeListener {

	@Override
	public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
		for (Field field : typeLiteral.getRawType().getDeclaredFields()) {
	        if (field.getType() == Logger.class
	            && field.isAnnotationPresent(InjectLogger.class)) {
	          typeEncounter.register(new Log4JMembersInjector<I>(field));
	        }
	      }
	}

}
