/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.library;

import com.thoughtworks.xstream.XStream;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.datatransfer.agent.library.DataSource;
import org.gcube.datatransfer.agent.library.DataStorage;
import org.gcube.datatransfer.agent.library.exceptions.CancelTransferException;
import org.gcube.datatransfer.agent.library.exceptions.ConfigurationException;
import org.gcube.datatransfer.agent.library.exceptions.GetTransferOutcomesException;
import org.gcube.datatransfer.agent.library.exceptions.MonitorTransferException;
import org.gcube.datatransfer.agent.library.exceptions.TransferException;
import org.gcube.datatransfer.agent.library.fws.AgentServiceJAXWSStubs;
import org.gcube.datatransfer.agent.library.grs.GRSFileWriter;
import org.gcube.datatransfer.agent.library.proxies.AgentService;
import org.gcube.datatransfer.agent.library.proxies.AgentServiceAsync;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.objs.LocalSource;
import org.gcube.datatransfer.common.objs.LocalSources;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferOutcome;
import org.gcube.datatransfer.common.outcome.TreeTransferOutcome;
import org.gcube.datatransfer.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentLibrary
implements AgentService,
AgentServiceAsync {
    private final AsyncProxyDelegate<AgentServiceJAXWSStubs> delegate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public AgentLibrary(ProxyDelegate<AgentServiceJAXWSStubs> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    @Override
    public ArrayList<TreeTransferOutcome> startTransferSync(Pattern patternInput, String inputSourceID, String outputStorageId) {
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(true);
        Types.DestData dest = new Types.DestData();
        dest.setOutSourceId(outputStorageId);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        Types.InputPattern input = new Types.InputPattern();
        try {
            input.setPattern(Utils.toHolder((Pattern)patternInput));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        input.setSourceId(inputSourceID);
        source.setInputSource(input);
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.TreeBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, ArrayList<TreeTransferOutcome>> call = new Call<AgentServiceJAXWSStubs, ArrayList<TreeTransferOutcome>>(){

            public ArrayList<TreeTransferOutcome> call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return Utils.getTreeOutcomes((String)endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String startTransfer(Pattern patternInput, String inputSourceID, String outputStorageId) throws TransferException {
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(false);
        Types.DestData dest = new Types.DestData();
        dest.setOutSourceId(outputStorageId);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        Types.InputPattern input = new Types.InputPattern();
        try {
            input.setPattern(Utils.toHolder((Pattern)patternInput));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        input.setSourceId(inputSourceID);
        source.setInputSource(input);
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.TreeBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ArrayList<FileTransferOutcome> startTransferSync(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options) throws TransferException, ConfigurationException {
        if (options.getType().name().compareTo(Types.storageType.StorageManager.name()) == 0 && options.getStorageManagerDetails() == null) {
            throw new ConfigurationException("The Storage Manager configuration details are missing");
        }
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(true);
        Types.DestData dest = new Types.DestData();
        Types.OutUriData outURI = new Types.OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(Arrays.asList(outputFolder));
        outURI.setOptions(this.fillTransferOptions(options));
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        String[] uris = new String[inputURIs.size()];
        for (int i = 0; i < inputURIs.size(); ++i) {
            uris[i] = inputURIs.get(i).toString();
        }
        source.setInputURIs(Arrays.asList(uris));
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.FileBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, ArrayList<? extends TransferOutcome>> call = new Call<AgentServiceJAXWSStubs, ArrayList<? extends TransferOutcome>>(){

            public ArrayList<? extends TransferOutcome> call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return Utils.getFileOutcomes((String)endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String startTransfer(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options) throws TransferException, ConfigurationException {
        if (options.getType().name().compareTo(Types.storageType.StorageManager.name()) == 0 && options.getStorageManagerDetails() == null) {
            throw new ConfigurationException("The Storage Manager configuration details are missing");
        }
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(false);
        Types.DestData dest = new Types.DestData();
        Types.OutUriData outURI = new Types.OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(Arrays.asList(outputFolder));
        outURI.setOptions(this.fillTransferOptions(options));
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        String[] uris = new String[inputURIs.size()];
        for (int i = 0; i < inputURIs.size(); ++i) {
            uris[i] = inputURIs.get(i).toString();
        }
        source.setInputURIs(Arrays.asList(uris));
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.FileBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void cancelTransfer(String transferId, boolean forceCancel) throws CancelTransferException {
        final Types.CancelTransferMessage cancelMessage = new Types.CancelTransferMessage();
        cancelMessage.setForceStop(forceCancel);
        cancelMessage.setTransferId(transferId);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.cancelTransfer(cancelMessage);
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (CancelTransferException e) {
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ArrayList<FileTransferOutcome> copyLocalFiles(ArrayList<File> inputFiles, String destinationFolder, boolean overwrite, boolean unzip) throws TransferException {
        GRSFileWriter writer = null;
        try {
            writer = new GRSFileWriter((IWriterProxy)new TCPWriterProxy(), inputFiles);
        }
        catch (GRS2WriterException e1) {
            e1.printStackTrace();
        }
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(true);
        Types.SourceData sourceData = new Types.SourceData();
        sourceData.setScope(ScopeProvider.instance.get());
        try {
            sourceData.setInputURIs(Arrays.asList(writer.getLocator().toString()));
        }
        catch (GRS2WriterException e1) {
            e1.printStackTrace();
        }
        sourceData.setType(Types.transferType.LocalFileBasedTransfer);
        Types.DestData destData = new Types.DestData();
        Types.OutUriData uri = new Types.OutUriData();
        if (destinationFolder.startsWith("/")) {
            destinationFolder = destinationFolder.substring(1);
        }
        uri.setOutUris(Arrays.asList(destinationFolder));
        Types.TransferOptions stubOptions = new Types.TransferOptions();
        stubOptions.setOverwrite(overwrite);
        if (unzip) {
            Types.postProcessType[] type = new Types.postProcessType[]{Types.postProcessType.FileUnzip};
        }
        uri.setOptions(stubOptions);
        destData.setOutUri(uri);
        message.setSource(sourceData);
        message.setDest(destData);
        writer.start();
        try {
            writer.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Call<AgentServiceJAXWSStubs, ArrayList<FileTransferOutcome>> call = new Call<AgentServiceJAXWSStubs, ArrayList<FileTransferOutcome>>(){

            public ArrayList<FileTransferOutcome> call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return Utils.getFileOutcomes((String)endpoint.startTransfer(message));
            }
        };
        try {
            return (ArrayList)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public ArrayList<LocalSource> getLocalSources(String path) {
        final String rootPath = path;
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getLocalSources(rootPath);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (result == null) {
            this.logger.debug("result from service = null");
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        try {
            XStream xstream = new XStream();
            LocalSources sources = new LocalSources();
            sources = (LocalSources)xstream.fromXML(tmpMsg);
            ArrayList<LocalSource> listToReturn = new ArrayList<LocalSource>();
            for (LocalSource source : sources.getList()) {
                listToReturn.add(source);
            }
            return listToReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String createTreeSource(String sourceID, String address, int port) {
        final Types.CreateTreeSourceMsg msg = new Types.CreateTreeSourceMsg();
        msg.setSourceID(sourceID);
        msg.setEndpoint(address);
        msg.setPort(port);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.createTreeSource(msg);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (result == null) {
            this.logger.debug("result from service = null");
        }
        return result;
    }

    public String removeGenericResource(final String sourceID) {
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.removeGenericResource(sourceID);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (result == null) {
            this.logger.debug("result from service = null");
        }
        return result;
    }

    public ArrayList<String> getTreeSources(final String reader_or_writer_TYPE) {
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getTreeSources(reader_or_writer_TYPE);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        if (result == null) {
            this.logger.debug("result from service = null");
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        try {
            XStream xstream = new XStream();
            ArrayList sourceIds = (ArrayList)xstream.fromXML(tmpMsg);
            return sourceIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Future<?> startTransfer(Pattern patternInput, String inputSourceID, String outputStorageId, Callback callback) {
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(false);
        Types.DestData dest = new Types.DestData();
        dest.setOutSourceId(outputStorageId);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        Types.InputPattern input = new Types.InputPattern();
        try {
            input.setPattern(Utils.toHolder((Pattern)patternInput));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        input.setSourceId(inputSourceID);
        source.setInputSource(input);
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.TreeBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return this.delegate.makeAsync((Call)call, callback);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public Future<?> startTransfer(ArrayList<URI> inputURIs, String outputFolder, TransferOptions options, Callback callback) throws ConfigurationException {
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(true);
        Types.DestData dest = new Types.DestData();
        Types.OutUriData outURI = new Types.OutUriData();
        if (outputFolder.startsWith("/")) {
            outputFolder = outputFolder.substring(1);
        }
        outURI.setOutUris(Arrays.asList(outputFolder));
        outURI.setOptions(this.fillTransferOptions(options));
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        String[] uris = new String[inputURIs.size()];
        for (int i = 0; i < inputURIs.size(); ++i) {
            uris[i] = inputURIs.get(i).toString();
        }
        source.setInputURIs(Arrays.asList(uris));
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.FileBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, ArrayList<? extends TransferOutcome>> call = new Call<AgentServiceJAXWSStubs, ArrayList<? extends TransferOutcome>>(){

            public ArrayList<? extends TransferOutcome> call(AgentServiceJAXWSStubs endpoint) throws Exception {
                if (message.getSource().getType().name().compareTo(Types.transferType.FileBasedTransfer.name()) == 0) {
                    return Utils.getFileOutcomes((String)endpoint.startTransfer(message));
                }
                return Utils.getTreeOutcomes((String)endpoint.startTransfer(message));
            }
        };
        try {
            return this.delegate.makeAsync((Call)call, callback);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String monitorTransfer(final String transferId) throws MonitorTransferException {
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.monitorTransfer(transferId);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (MonitorTransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <T extends TransferOutcome> ArrayList<T> getTransferOutcomes(final String transferId, final Class<T> outcomeType) throws GetTransferOutcomesException {
        Call call = new Call<AgentServiceJAXWSStubs, ArrayList<T>>(){

            public ArrayList<T> call(AgentServiceJAXWSStubs endpoint) throws Exception {
                if (outcomeType.getName().compareTo(FileTransferOutcome.class.getName()) == 0) {
                    AgentLibrary.this.logger.debug("FileTransferOutcome ... ");
                    String rs = endpoint.getTransferOutcomes(transferId);
                    if (rs == null) {
                        return null;
                    }
                    return Utils.getFileOutcomes((String)rs);
                }
                AgentLibrary.this.logger.debug("TreeTransferOutcome ... ");
                String rs = endpoint.getTransferOutcomes(transferId);
                if (rs == null) {
                    return null;
                }
                return Utils.getTreeOutcomes((String)rs);
            }
        };
        try {
            return (ArrayList)this.delegate.make(call);
        }
        catch (GetTransferOutcomesException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public String startTransfer(DataSource source, DataStorage storage, TransferOptions options) throws ConfigurationException, TransferException {
        return null;
    }

    @Override
    public String startTransfer(ArrayList<URI> inputURIs, ArrayList<URI> outputURIs, TransferOptions options) throws ConfigurationException, TransferException {
        if (options.getType().name().compareTo(Types.storageType.DataStorage.name()) != 0) {
            throw new ConfigurationException("The operation is available only selecting DataStorage as storage Type");
        }
        final Types.StartTransferMessage message = new Types.StartTransferMessage();
        message.setSyncOp(false);
        Types.DestData dest = new Types.DestData();
        Types.OutUriData outURI = new Types.OutUriData();
        String[] outURIs = new String[outputURIs.size()];
        for (int i = 0; i < outputURIs.size(); ++i) {
            outURIs[i] = outputURIs.get(i).toString();
        }
        outURI.setOutUris(Arrays.asList(outURIs));
        Types.TransferOptions stubOptions = new Types.TransferOptions();
        stubOptions.setOverwrite(options.isOverwriteFile());
        stubOptions.setStorageType(options.getType());
        stubOptions.setTransferTimeout(options.getTransferTimeout());
        outURI.setOptions(stubOptions);
        dest.setOutUri(outURI);
        dest.setScope(ScopeProvider.instance.get());
        message.setDest(dest);
        Types.SourceData source = new Types.SourceData();
        String[] uris = new String[inputURIs.size()];
        for (int i = 0; i < inputURIs.size(); ++i) {
            uris[i] = inputURIs.get(i).toString();
        }
        source.setInputURIs(Arrays.asList(uris));
        source.setScope(ScopeProvider.instance.get());
        source.setType(Types.transferType.FileBasedTransfer);
        message.setSource(source);
        Call<AgentServiceJAXWSStubs, String> call = new Call<AgentServiceJAXWSStubs, String>(){

            public String call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.startTransfer(message);
            }
        };
        try {
            return (String)this.delegate.make((Call)call);
        }
        catch (TransferException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (ServiceException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new ServiceException((Throwable)e);
        }
    }

    private Types.TransferOptions fillTransferOptions(TransferOptions options) {
        Types.TransferOptions stubOptions = new Types.TransferOptions();
        stubOptions.setOverwrite(options.isOverwriteFile());
        stubOptions.setStorageType(options.getType());
        stubOptions.setTransferTimeout(options.getTransferTimeout());
        int size = 0;
        if (options.isCovertFile()) {
            ++size;
        }
        if (options.isUnzipFile()) {
            ++size;
        }
        if (options.isDeleteOriginalFile()) {
            ++size;
        }
        if (size != 0) {
            int i = 0;
            Types.postProcessType[] type = new Types.postProcessType[size];
            if (options.isUnzipFile()) {
                type[i] = Types.postProcessType.FileUnzip;
                ++i;
            }
            if (options.isCovertFile()) {
                type[i] = Types.postProcessType.FileConversion;
                stubOptions.setConversionType(options.getConversionType().name());
                ++i;
            }
            if (options.isDeleteOriginalFile()) {
                type[i] = Types.postProcessType.OriginalFileRemove;
            }
            stubOptions.setPostProcess(Arrays.asList(type));
        }
        if (options.getType().name().compareTo(Types.storageType.StorageManager.name()) == 0) {
            stubOptions.setStorageManagerDetails(options.getStorageManagerDetails());
        }
        return stubOptions;
    }

    @Override
    public Types.MonitorTransferReportMessage monitorTransferWithProgress(final String transferId) throws MonitorTransferException {
        Call<AgentServiceJAXWSStubs, Types.MonitorTransferReportMessage> call = new Call<AgentServiceJAXWSStubs, Types.MonitorTransferReportMessage>(){

            public Types.MonitorTransferReportMessage call(AgentServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.monitorTransferWithProgress(transferId);
            }
        };
        try {
            return (Types.MonitorTransferReportMessage)this.delegate.make((Call)call);
        }
        catch (MonitorTransferException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    static {
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(4000, 4050));
        try {
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(InetAddress.getLocalHost().getHostName(), ports, true));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }
}

