/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.nio.file.Paths;
import java.util.List;
import org.cache2k.Cache;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    public static Logger logger = LoggerFactory.getLogger(PathUtils.class);
    private Cache<String, ItemContainer<Item>> cache;
    private FolderContainer rootDirectory;
    private StorageHubClient client;

    public PathUtils(Cache<String, ItemContainer<Item>> cache, FolderContainer rootDirectory, StorageHubClient client) {
        this.cache = cache;
        this.rootDirectory = rootDirectory;
        this.client = client;
    }

    public String getLastComponent(String path) {
        while (path.substring(path.length() - 1).equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return "";
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getParentPath(String path) {
        return Paths.get(path, new String[0]).getParent().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemContainer<? extends Item> getPath(String path) {
        if (path.equals("/")) {
            return this.rootDirectory;
        }
        if (this.cache.containsKey((Object)path)) {
            ItemContainer cached = (ItemContainer)this.cache.peek((Object)path);
            logger.trace("path " + path + " retrieved in cache with id " + cached.getId());
            return cached;
        }
        logger.trace("path " + path + " not in cache");
        PathUtils pathUtils = this;
        synchronized (pathUtils) {
            ItemContainer<? extends Item> retrievedItem = this.getPathRecursive(path, this.rootDirectory);
            if (retrievedItem != null) {
                this.cache.put((Object)path, retrievedItem);
            }
            return retrievedItem;
        }
    }

    public ItemContainer<? extends Item> getPathRecursive(String path, FolderContainer parentContainer) {
        try {
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.contains("/")) {
                logger.trace("seaching path " + path + " in " + ((FolderItem)parentContainer.get()).getTitle());
                List items = parentContainer.findByName(path).withContent().getContainers();
                logger.trace("found? " + (items.size() > 0));
                return items.size() > 0 ? (ItemContainer)items.get(0) : null;
            }
            if (path.startsWith("VREFolders")) {
                List vreFolders = this.client.getVREFolders().getContainers();
                String vreName = path.split("/")[1];
                for (ItemContainer vreContainer : vreFolders) {
                    SharedFolder veFolder = (SharedFolder)vreContainer.get();
                    if (!veFolder.getDisplayName().equals(vreName)) continue;
                    String nextPath = path.replace("VREFolders/" + veFolder.getDisplayName(), "");
                    if (nextPath.isEmpty()) {
                        return vreContainer;
                    }
                    return this.getPathRecursive(nextPath, (FolderContainer)vreContainer);
                }
            }
            String nextName = path.substring(0, path.indexOf("/"));
            String rest = path.substring(path.indexOf("/"));
            for (ItemContainer container : parentContainer.findByName(nextName).withContent().getContainers()) {
                if (!(container instanceof FolderContainer)) continue;
                logger.trace("seaching path " + rest + " in " + container.get().getTitle());
                return this.getPathRecursive(rest, (FolderContainer)container);
            }
        }
        catch (Exception e) {
            logger.error("error in gpath recursive", (Throwable)e);
        }
        return null;
    }
}

