/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.IOException;
import java.io.InputStream;
import jnr.ffi.Pointer;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.struct.FileStat;

public class FileDownload
implements SHFile {
    public static Logger logger = LoggerFactory.getLogger(FileDownload.class);
    InputStream stream;
    AbstractFileItem fileItem;
    Object monitor = new Object();
    long offset = 0L;

    public FileDownload(FileContainer fileContainer) throws Exception {
        this.stream = fileContainer.download(new String[0]).getStream();
        this.fileItem = (AbstractFileItem)fileContainer.get();
        logger.trace("FILE-DOWNLOAD initialized with {} , {}", (Object)this.fileItem.getName(), (Object)this.fileItem.getContent().getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(Pointer buf, long size, long offset) {
        logger.trace("{} read called with size {} and offset {} ", new Object[]{this.fileItem.getName(), size, offset});
        while (this.offset != offset) {
            logger.trace("going in wait ({},{})", (Object)this.offset, (Object)offset);
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.monitor.wait();
                    logger.trace("waking up!!!");
                }
                catch (InterruptedException e2) {
                    logger.warn("interrupt exception", (Throwable)e2);
                }
            }
        }
        int bytesToRead = (int)size;
        byte[] mybuf = new byte[bytesToRead];
        int readTotal = 0;
        try {
            int read = 0;
            logger.trace("{} BEFORE: bytes to read {} and read total {} and last read {}", new Object[]{this.fileItem.getName(), bytesToRead, readTotal, read});
            while ((read = this.stream.read(mybuf, 0, bytesToRead - readTotal)) != -1 && bytesToRead > readTotal) {
                buf.put((long)readTotal, mybuf, 0, read);
                logger.trace("{} INSIDE: bytes to read {} and read total {} and last read {}", new Object[]{this.fileItem.getName(), bytesToRead, readTotal += read, read});
            }
            logger.trace("{} AFTER: bytes to read {} and read total {} and last read {}", new Object[]{this.fileItem.getName(), bytesToRead, readTotal, read});
        }
        catch (Exception e) {
            logger.error("error in read", (Throwable)e);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = -ErrorCodes.ENOENT();
            return n;
        }
        finally {
            this.offset = (long)readTotal + offset;
            logger.trace("setting offset to {}", (Object)this.offset);
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
        logger.trace("{} work finished!!! {}", (Object)this.fileItem.getName(), (Object)readTotal);
        return readTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int flush() {
        logger.trace("called flush");
        try {
            this.stream.close();
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
        catch (IOException e1) {
            logger.error("error closing stream", (Throwable)e1);
        }
        return 0;
    }

    @Override
    public int getAttr(FileStat stat) {
        logger.trace("is in download");
        stat.st_mode.set((Number)33133);
        stat.st_size.set((Number)this.fileItem.getContent().getSize());
        stat.st_mtim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_atim.tv_sec.set(this.fileItem.getLastModificationTime().toInstant().getEpochSecond());
        return 0;
    }
}

