/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.fs;

import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jnr.ffi.Pointer;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.fs.FSInputStream;
import org.gcube.data.access.storagehub.fs.FileDownload;
import org.gcube.data.access.storagehub.fs.FileUpload;
import org.gcube.data.access.storagehub.fs.PathUtils;
import org.gcube.data.access.storagehub.fs.SHFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;

public class StorageHubFS
extends FuseStubFS {
    public static Logger logger = LoggerFactory.getLogger(StorageHubFS.class);
    StorageHubClient client;
    String token;
    String scope;
    HashMap<String, SHFile> tempFiles = new HashMap();
    static final String VREFOLDERS_NAME = "VREFolders";
    Cache<String, ItemContainer<Item>> cache;
    PathUtils pathUtils;
    private FolderContainer rootDirectory;

    public StorageHubFS(String token, String scope) {
        this.token = token;
        this.scope = scope;
        ScopeProvider.instance.set(scope);
        SecurityTokenProvider.instance.set(token);
        this.client = new StorageHubClient();
        this.rootDirectory = this.client.getWSRoot();
        this.cache = new Cache2kBuilder<String, ItemContainer<Item>>(){}.expireAfterWrite(30L, TimeUnit.SECONDS).resilienceDuration(30L, TimeUnit.SECONDS).build();
        this.pathUtils = new PathUtils(this.cache, this.rootDirectory);
    }

    public synchronized int write(String path, Pointer buf, long size, long offset, FuseFileInfo fi) {
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace(Thread.currentThread().getName() + " ) calling write " + size + " " + offset);
        SHFile file = this.tempFiles.get(path);
        return file.write(buf, size, offset);
    }

    public synchronized int flush(String path, FuseFileInfo fi) {
        logger.trace("called flush for " + path);
        this.tempFiles.get(path).flush();
        this.tempFiles.remove(path);
        return 0;
    }

    public synchronized int create(final String path, @mode_t long mode, FuseFileInfo fi) {
        ItemContainer<? extends Item> parentContainer;
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace(Thread.currentThread().getName() + " ) calling create " + path);
        if (this.pathUtils.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        if (path.substring(1).contains("/")) {
            String parentPath = Paths.get(path, new String[0]).getParent().toString();
            parentContainer = this.pathUtils.getPath(parentPath);
        } else {
            parentContainer = this.rootDirectory;
        }
        final FSInputStream stream = new FSInputStream();
        FileUpload fileUpload = new FileUpload(stream);
        this.tempFiles.put(path, fileUpload);
        new Thread(AuthorizedTasks.bind((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ((FolderContainer)parentContainer).uploadFile((InputStream)stream, StorageHubFS.this.pathUtils.getLastComponent(path), "");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    StorageHubFS.this.tempFiles.get(path).flush();
                }
            }
        })).start();
        return 0;
    }

    public int getattr(String path, FileStat stat) {
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace(Thread.currentThread().getName() + " ) calling getattr " + path);
        if (Objects.equals(path, "/") || path.contains("Trash") || path.equals("/VREFolders")) {
            stat.st_mode.set((Number)16877);
            stat.st_nlink.set((Number)2);
        } else {
            if (this.pathUtils.getLastComponent(path).startsWith(".")) {
                logger.trace("start with /.");
                return super.getattr(path, stat);
            }
            if (this.tempFiles.containsKey(path)) {
                return this.tempFiles.get(path).getAttr(stat);
            }
            logger.trace("trying items");
            ItemContainer<? extends Item> container = this.pathUtils.getPath(path);
            logger.trace("item for path " + path + " is null ? " + (container == null));
            if (container == null) {
                return -ErrorCodes.ENOENT();
            }
            try {
                this.getAttrSHItem(container, stat);
            }
            catch (Throwable e) {
                logger.error("error gettign attributes ", e);
                return -ErrorCodes.ENOENT();
            }
        }
        return 0;
    }

    private void getAttrSHItem(ItemContainer<? extends Item> container, FileStat stat) throws IllegalArgumentException {
        if (container.getType() == ContainerType.FILE) {
            AbstractFileItem fileItem = (AbstractFileItem)container.get();
            stat.st_size.set((Number)fileItem.getContent().getSize());
            this.setCommonAttributes((Item)fileItem, stat, 32768);
            logger.trace("fileContent is " + fileItem.getContent().getSize());
        } else if (container.getType() == ContainerType.FOLDER) {
            FolderItem folderItem = (FolderItem)container.get();
            stat.st_size.set((Number)4096);
            this.setCommonAttributes((Item)folderItem, stat, 16384);
        } else {
            throw new IllegalArgumentException("container type not valid");
        }
    }

    private void setCommonAttributes(Item item, FileStat stat, int type) {
        if (item.isShared()) {
            stat.st_mode.set((Number)(type | 4));
        } else {
            stat.st_mode.set((Number)(type | 0x1ED));
        }
        stat.st_mtim.tv_sec.set(item.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_mtim.tv_nsec.set((Number)item.getLastModificationTime().toInstant().getNano());
        stat.st_ctim.tv_sec.set(item.getCreationTime().toInstant().getEpochSecond());
        stat.st_ctim.tv_nsec.set((Number)item.getCreationTime().toInstant().getNano());
        stat.st_atim.tv_sec.set(item.getLastModificationTime().toInstant().getEpochSecond());
        stat.st_atim.tv_nsec.set((Number)item.getLastModificationTime().toInstant().getNano());
    }

    public int mkdir(String path, @mode_t long mode) {
        ItemContainer<? extends Item> parentContainer;
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace(Thread.currentThread().getName() + " ) calling mkdir");
        if (this.pathUtils.getPath(path) != null) {
            return -ErrorCodes.EEXIST();
        }
        if (path.substring(1).contains("/")) {
            String parentPath = Paths.get(path, new String[0]).getParent().toString();
            parentContainer = this.pathUtils.getPath(parentPath);
        } else {
            parentContainer = this.rootDirectory;
        }
        ItemContainer<? extends Item> parentDir = parentContainer;
        String dirName = this.pathUtils.getLastComponent(path);
        try {
            parentDir.newFolder(dirName, dirName);
            return 0;
        }
        catch (Exception e) {
            logger.error("error in mkdir", (Throwable)e);
            return -ErrorCodes.ENOENT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        SHFile fileDownload;
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace("!!! read called in path {} with size {} and offset {} ", new Object[]{path, size, offset});
        HashMap<String, SHFile> hashMap = this.tempFiles;
        synchronized (hashMap) {
            if (this.tempFiles.containsKey(path)) {
                fileDownload = this.tempFiles.get(path);
            } else {
                ItemContainer<? extends Item> item = this.pathUtils.getPath(path);
                if (item == null) {
                    return -ErrorCodes.ENOENT();
                }
                if (item.getType() != ContainerType.FILE) {
                    return -ErrorCodes.EISDIR();
                }
                try {
                    fileDownload = new FileDownload((FileContainer)item);
                }
                catch (Exception e) {
                    logger.error("error reading remote file", (Throwable)e);
                    return -ErrorCodes.ENOENT();
                }
                this.tempFiles.put(path, fileDownload);
            }
        }
        return fileDownload.read(buf, size, offset);
    }

    public int readdir(String path, Pointer buf, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        List containers;
        logger.trace("readdir called");
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        logger.trace(Thread.currentThread().getName() + " ) calling readdir " + path);
        if (path.contains(".Trash")) {
            return 0;
        }
        if (path.equals("/VREFolders")) {
            try {
                containers = this.client.getVREFolders().getContainers();
            }
            catch (StorageHubException she) {
                logger.error("error reading dir", (Throwable)she);
                return -ErrorCodes.EACCES();
            }
        }
        ItemContainer<? extends Item> container = this.pathUtils.getPath(path);
        if (container == null) {
            return -ErrorCodes.ENOENT();
        }
        if (container.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        try {
            logger.trace("reading folder " + path);
            containers = ((FolderContainer)container).list().withContent().getContainers();
            logger.trace("folder read " + path);
        }
        catch (UserNotAuthorizedException userNotAuthorizedException) {
            logger.error("folder error ", (Throwable)userNotAuthorizedException);
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException storageHubException) {
            logger.error("folder error ", (Throwable)storageHubException);
            return -ErrorCodes.EREMOTEIO();
        }
        catch (Throwable throwable) {
            logger.error("folder error ", throwable);
            throw new RuntimeException(throwable);
        }
        filter.apply(buf, ".", null, 0L);
        filter.apply(buf, "..", null, 0L);
        for (ItemContainer itemContainer : containers) {
            try {
                Item it = itemContainer.get();
                filter.apply(buf, it.getTitle(), null, 0L);
                if (path.charAt(path.length() - 1) != '/') {
                    path = path + "/";
                }
                this.cache.put((Object)(path + it.getTitle()), (Object)itemContainer);
            }
            catch (Exception e) {
                logger.error("error riding children ", (Throwable)e);
            }
        }
        logger.trace("tempFiles.entrySet() is empty ? {}", (Object)this.tempFiles.entrySet().isEmpty());
        for (Map.Entry entry : this.tempFiles.entrySet()) {
            logger.trace("entry in temp map {}", entry.getKey());
            if (!(entry.getValue() instanceof FileUpload) || !this.pathUtils.getParentPath((String)entry.getKey()).equals(path)) continue;
            filter.apply(buf, this.pathUtils.getLastComponent((String)entry.getKey()), null, 0L);
            logger.trace("last temp entry added {}", entry.getKey());
        }
        if (path.equals("/")) {
            filter.apply(buf, VREFOLDERS_NAME, null, 0L);
        }
        return 0;
    }

    public int rename(String path, String newName) {
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        ItemContainer<? extends Item> folder = this.pathUtils.getPath(path);
        if (folder == null) {
            return -ErrorCodes.ENOENT();
        }
        ItemContainer<? extends Item> newParent = this.pathUtils.getPath(this.pathUtils.getParentPath(newName));
        if (newParent == null) {
            return -ErrorCodes.ENOENT();
        }
        if (newParent.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        try {
            if (newParent.getId() != folder.get().getParentId()) {
                folder.move((FolderContainer)newParent);
            }
            if (!this.pathUtils.getLastComponent(newName).equals(this.pathUtils.getLastComponent(path))) {
                folder.rename(this.pathUtils.getLastComponent(newName));
            }
            this.cache.remove((Object)path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    public int rmdir(String path) {
        if (path.equals("/VREFolders")) {
            return -ErrorCodes.EACCES();
        }
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        ItemContainer<? extends Item> folder = this.pathUtils.getPath(path);
        if (folder == null) {
            return -ErrorCodes.ENOENT();
        }
        if (folder.getType() != ContainerType.FOLDER) {
            return -ErrorCodes.ENOTDIR();
        }
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        try {
            this.checkSpecialFolderRemove(path);
            if (folder.get() instanceof SharedFolder && ((SharedFolder)folder.get()).isVreFolder()) {
                return -ErrorCodes.EACCES();
            }
            folder.delete();
            this.cache.remove((Object)path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    public void checkSpecialFolderRemove(String path) throws UserNotAuthorizedException {
        if (path.equals(String.format("/%s", VREFOLDERS_NAME))) {
            throw new UserNotAuthorizedException("VREFolders cannot be deleted");
        }
    }

    public int unlink(String path) {
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        ItemContainer<? extends Item> file = this.pathUtils.getPath(path);
        if (file == null) {
            return -ErrorCodes.ENOENT();
        }
        if (file.getType() != ContainerType.FILE) {
            return -ErrorCodes.EISDIR();
        }
        ScopeProvider.instance.set(this.scope);
        SecurityTokenProvider.instance.set(this.token);
        try {
            file.delete();
            this.cache.remove((Object)path);
        }
        catch (UserNotAuthorizedException una) {
            return -ErrorCodes.EACCES();
        }
        catch (StorageHubException she) {
            return -ErrorCodes.EREMOTEIO();
        }
        return 0;
    }

    public int open(String path, FuseFileInfo fi) {
        logger.info("open called");
        return 0;
    }
}

