/**
 * 
 */
package org.gcube.portlets.user.tdcolumnoperation.client.specificoperation;

import java.util.List;

import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.tdcolumnoperation.client.properties.AggregateFunctionPropertiesCombo;
import org.gcube.portlets.user.tdcolumnoperation.client.properties.ColumnDataPropertiesCombo;
import org.gcube.portlets.user.tdcolumnoperation.shared.TdAggregateFunction;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.HTML;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.ComboBox;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jun 9, 2014
 *
 */
public class ComboColumnDataFunctionPanel {

	
	private ComboBox<ColumnData> comboColumn;
	private ComboBox<TdAggregateFunction> comboFunction;
	private List<ColumnData> columns;
	private List<TdAggregateFunction> functions;
	private int index;
	private HBoxLayoutContainer hBox;
	private HTML error = new HTML();
	private VerticalLayoutContainer vertical;
	
	private boolean isValid;
	
	private GroupByFormValidator validator = new GroupByFormValidator();
	/**
	 * 
	 */
	public ComboColumnDataFunctionPanel(int index, List<ColumnData> columns, List<TdAggregateFunction> functions) {
		this.columns = columns;
		this.functions = functions;
		this.index = index;
		initComboColumnName();
		initComboColumnFunction();
		
		HBoxLayoutContainer hBox = new HBoxLayoutContainer();
		hBox.add(comboColumn, new BoxLayoutData(new Margins(0)));
		hBox.add(comboFunction, new BoxLayoutData(new Margins(0,0,0,10)));
		
		vertical = new VerticalLayoutContainer();
		vertical.setScrollMode(ScrollMode.AUTO);
		vertical.add(hBox, new VerticalLayoutData(1, -1, new Margins(0)));
		
		vertical.add(error, new VerticalLayoutData(1, -1, new Margins(5,1,10,1)));
	}
	
	/**
	 * 
	 */
	private void initComboColumnName() {
		
		// Column Data
		ColumnDataPropertiesCombo propsColumnData = GWT.create(ColumnDataPropertiesCombo.class);
		ListStore<ColumnData> storeCombo = new ListStore<ColumnData>(propsColumnData.id());

		storeCombo.addAll(columns);
		comboColumn = new ComboBox<ColumnData>(storeCombo, propsColumnData.label());
		comboColumn.setAllowBlank(false);

		comboColumn.addSelectionHandler(new SelectionHandler<ColumnData>() {
			
			public void onSelection(SelectionEvent<ColumnData> event) {
				
			}

		});

		comboColumn.setEmptyText("Select a column...");
		comboColumn.setWidth(150);
		comboColumn.setTypeAhead(false);
		comboColumn.setEditable(false);
		comboColumn.setTriggerAction(TriggerAction.ALL);

	}
	
	
	/**
	 * 
	 */
	private void initComboColumnFunction() {
		
		// Column Data
		AggregateFunctionPropertiesCombo propsColumnData = GWT.create(AggregateFunctionPropertiesCombo.class);
		ListStore<TdAggregateFunction> storeCombo = new ListStore<TdAggregateFunction>(propsColumnData.id());

		storeCombo.addAll(functions);
		comboFunction = new ComboBox<TdAggregateFunction>(storeCombo, propsColumnData.label());
		comboFunction.setAllowBlank(false);

		comboFunction.addSelectionHandler(new SelectionHandler<TdAggregateFunction>() {
			
			public void onSelection(SelectionEvent<TdAggregateFunction> event) {
				
			}

		});

		comboFunction.setEmptyText("Select a function...");
		comboFunction.setWidth(150);
		comboFunction.setTypeAhead(false);
		comboFunction.setEditable(false);
		comboFunction.setTriggerAction(TriggerAction.ALL);

	}
	
	public void errorText(String text){
		String html = "<p style=\"color:red\">"+text+"</p>";
		error.setHTML(html);
		vertical.forceLayout();
	}
	
	public boolean validate(List<ColumnData> selectedColumns){
		if(comboColumn.getCurrentValue()==null){
//			UtilsGXT3.alert("Attention", "Insert 'Column Name' for field : "+index);
			errorText("Select aggregate 'Column Name'");
			return isValid = false;
		}else if(comboFunction.getCurrentValue()==null){
//			UtilsGXT3.alert("Attention", "Insert field 'Function' for field: "+index);
			errorText("Select aggregate 'Function'");
			return isValid = false;
		}else{
			
			validator.selectColumnsData(selectedColumns);
			ColumnData aggregate = getColumnDataSelected();
			validator.selectAggregateData(aggregate);
			if(validator.containsDataAggregate()){
				errorText("Group By Column "+aggregate.getLabel() +" must not be an aggregate column!");
				return isValid = false;
			}
		}
		
		return isValid = true;
	}
	
	public VerticalLayoutContainer getPanel(){
		return vertical;
	}
	
	public ColumnData getColumnDataSelected(){
		return comboColumn.getCurrentValue();
	}
	
	public TdAggregateFunction getFunctionSelected(){
		return comboFunction.getCurrentValue();
	}

	public void setValid(boolean isValid) {
		this.isValid = isValid;
	}

	public boolean isValid() {
		return isValid;
	}

}
