/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.services;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporterFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.dtos.ConfigurationCriteriaDto;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.ConfigurationRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.querying.ConfigurationCriteria;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.ConfigurationService;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DataDocumentMetadata;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger logger = LogManager.getLogger(ConfigurationServiceImpl.class);
    private ConfigurationRepository configurationDAO;
    private DataDocumentRepository dataDocumentDAO;
    private ModelMapper modelMapper;
    private RawDataImporterFactory rawDataImporterFactory;

    @Autowired
    public ConfigurationServiceImpl(ConfigurationRepository configurationDAO, DataDocumentRepository dataDocumentDAO, ModelMapper modelMapper, RawDataImporterFactory rawDataImporterFactory) {
        this.configurationDAO = configurationDAO;
        this.dataDocumentDAO = dataDocumentDAO;
        this.modelMapper = modelMapper;
        this.rawDataImporterFactory = rawDataImporterFactory;
    }

    @Override
    public Configuration getConfiguration(String id) throws Exception {
        return this.configurationDAO.getById(id);
    }

    @Override
    public List<Configuration> getConfigurations(ConfigurationCriteriaDto criteriaDto, String vre) throws Exception {
        ConfigurationCriteria criteria = (ConfigurationCriteria)this.modelMapper.map((Object)criteriaDto, ConfigurationCriteria.class);
        criteria.setVre(vre);
        return this.configurationDAO.getConfigurations(criteria);
    }

    @Override
    public DataDocument getDataDocument(String id) throws Exception {
        return this.dataDocumentDAO.getById(id);
    }

    @Override
    public DataDocumentMetadata getDataDocumentMetadata(String id) throws Exception {
        return (DataDocumentMetadata)this.modelMapper.map((Object)this.dataDocumentDAO.getById(id), DataDocumentMetadata.class);
    }

    @Override
    public String storeConfiguration(Configuration item) throws Exception {
        if (item.getId() == null) {
            item.setCreatedAt(new Date());
        }
        item.setUpdatedAt(new Date());
        if (item.getId() == null) {
            return this.configurationDAO.create(item);
        }
        this.configurationDAO.update(item);
        return item.getId();
    }

    @Override
    public String storeDataDocument(String vre, String name, DataType type, boolean isDataReference, byte[] content, String delimiter, String commentChar) throws Exception {
        logger.info("Storing document with name " + name + " and datatype " + (Object)((Object)type));
        DataDocument dataDocument = new DataDocument();
        dataDocument.setVre(vre);
        dataDocument.setName(name);
        dataDocument.setType(type);
        dataDocument.setDataReference(isDataReference);
        dataDocument.setDelimiter(delimiter);
        dataDocument.setCommentChar(commentChar);
        RawDataImporter importer = this.rawDataImporterFactory.getImporter(type);
        importer.importData(content, dataDocument);
        dataDocument.setCreatedAt(new Date());
        dataDocument.setUpdatedAt(new Date());
        String id = this.dataDocumentDAO.store(dataDocument);
        logger.info("Document stored with id " + id);
        return id;
    }

    @Override
    public void deleteConfiguration(String id) throws Exception {
        this.configurationDAO.delete(id);
    }
}

