/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.mapper;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMapper {
    public static Node getNode(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            return node;
        }
        return null;
    }

    public static List<Node> getNodes(String tagName, NodeList nodes) {
        ArrayList<Node> subNodes = new ArrayList<Node>();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            subNodes.add(node);
        }
        return subNodes;
    }

    public static String getNodeValue(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int x = 0; x < childNodes.getLength(); ++x) {
            Node data = childNodes.item(x);
            if (data.getNodeType() != 3) continue;
            return data.getNodeValue();
        }
        return "";
    }

    public static String getNodeValue(String tagName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            NodeList childNodes = node.getChildNodes();
            for (int y = 0; y < childNodes.getLength(); ++y) {
                Node data = childNodes.item(y);
                if (data.getNodeType() != 3) continue;
                return data.getNodeValue();
            }
        }
        return "";
    }

    public static String getNodeAttr(String attrName, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        for (int y = 0; y < attrs.getLength(); ++y) {
            Node attr = attrs.item(y);
            if (!attr.getNodeName().equalsIgnoreCase(attrName)) continue;
            return attr.getNodeValue();
        }
        return "";
    }

    public static String getNodeAttr(String tagName, String attrName, NodeList nodes) {
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (!node.getNodeName().equalsIgnoreCase(tagName)) continue;
            NodeList childNodes = node.getChildNodes();
            for (int y = 0; y < childNodes.getLength(); ++y) {
                Node data = childNodes.item(y);
                if (data.getNodeType() != 2 || !data.getNodeName().equalsIgnoreCase(attrName)) continue;
                return data.getNodeValue();
            }
        }
        return "";
    }
}

