/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.http;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import gr.uoa.di.aginfra.data.analytics.visualization.model.interceptors.RequestLoggingInterceptor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.mapper.XMLMapper;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.geojson.FeatureCollection;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HttpClient
extends RestTemplate {
    private static HttpClient instance = null;

    private HttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClient getInstance() {
        if (instance != null) return instance;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (instance != null) return instance;
            instance = new HttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public FeatureCollection getRequest(String url, Map<String, String> headers, Map<String, Object> parameters) {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        restTemplate.setInterceptors(Collections.singletonList(new RequestLoggingInterceptor()));
        HttpEntity entity = null;
        if (headers != null) {
            HttpHeaders httpHeaders = this.setHttpHeaders(headers);
            entity = new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (parameters != null) {
            url = this.setParameters(parameters, url);
        }
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, FeatureCollection.class, new Object[0]);
            return (FeatureCollection)response.getBody();
        }
        catch (HttpServerErrorException e) {
            System.out.println(e.getMessage());
            System.out.println(e.getResponseBodyAsString());
            return new FeatureCollection();
        }
    }

    public Map<String, String> workspaceGetRequest(String url, Map<String, String> headers, Map<String, Object> parameters) throws IOException, SAXException {
        HashMap<String, String> results = new HashMap<String, String>();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        restTemplate.setInterceptors(Collections.singletonList(new RequestLoggingInterceptor()));
        HttpEntity entity = null;
        if (headers != null) {
            HttpHeaders httpHeaders = this.setHttpHeaders(headers);
            entity = new HttpEntity((MultiValueMap)httpHeaders);
        }
        if (parameters != null) {
            url = this.setParameters(parameters, url);
        }
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            results.put("body", (String)response.getBody());
            return results;
        }
        catch (HttpServerErrorException e) {
            System.out.println(e.getMessage());
            String message = null;
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(new StringReader(e.getResponseBodyAsString()));
            parser.parse(is);
            Document doc = parser.getDocument();
            NodeList root = doc.getChildNodes();
            Node executeResponse = XMLMapper.getNode("ows:ExceptionReport", root);
            List<Node> processOutputs = XMLMapper.getNodes("ows:Exception", executeResponse.getChildNodes());
            NodeList nodes = processOutputs.get(0).getChildNodes();
            message = XMLMapper.getNodeValue("ows:ExceptionText", nodes);
            results.put("body", null);
            results.put("message", message);
            System.out.println(e.getResponseBodyAsString());
            return results;
        }
    }

    private String postRequest(String url) {
        return null;
    }

    private HttpHeaders setHttpHeaders(Map<String, String> headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpHeaders.set(entry.getKey(), entry.getValue());
        }
        return httpHeaders;
    }

    private String setParameters(Map<String, Object> parameters, String url) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            builder.queryParam(parameter.getKey(), new Object[]{parameter.getValue()});
        }
        System.out.println(builder.build().toString());
        return builder.build().toString();
    }

    private ClientHttpRequestFactory getClientHttpRequestFactory() {
        int timeout = 45000;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        return new HttpComponentsClientHttpRequestFactory((org.apache.http.client.HttpClient)client);
    }
}

