/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.helpers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.config.NetworkGraphConfig;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.DateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasDateNode;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.HasWeight;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.Node;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.NodeProperty;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.netgraph.TopNodesResult;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.NetworkGraphPositioningHelper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.services.NetworkGraphService;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.ogm.session.Utils;
import org.springframework.beans.factory.annotation.Autowired;

public class GraphVisualizationHelper {
    private static int minSize = 200;
    @Autowired
    private NetworkGraphConfig config;

    public static Map<String, Object> nodesToD3Format(Collection<Node> nodeEntities, boolean isInitialization, String graphId) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        int i = 0;
        for (Node node : nodeEntities) {
            Point2D point2D = NetworkGraphPositioningHelper.getInstance().addPositions(graphId + node.getId());
            Map nodeMap = node.getX() != 0.0 ? Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor(), "x", point2D.getX(), "y", point2D.getY()}) : Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor()});
            for (NodeProperty property : node.getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            double value = 0.0;
            for (HasDateNode hasDateNode : node.getHasDateNodes()) {
                double temp = Double.parseDouble(hasDateNode.getTarget().getProperty());
                if (temp > value) {
                    value = Double.parseDouble(hasDateNode.getTarget().getProperty());
                }
                rels.add(Utils.map((Object[])new Object[]{"source", node.getNodeId(), "target", hasDateNode.getTarget().getHasWeight().getTarget().getParentId(), "weight", hasDateNode.getTarget().getHasWeight().getWeight(), "color", "lightblue", "highlightColor", "lightblue"}));
            }
            nodeMap.put("value", value);
            nodes.add(nodeMap);
        }
        if (isInitialization && rels.size() == 0) {
            Node source = null;
            for (Node node : nodeEntities) {
                if (i > 0) {
                    rels.add(Utils.map((Object[])new Object[]{"source", source.getNodeId(), "target", node.getNodeId(), "color", "transparent", "highlightColor", "lightblue"}));
                } else {
                    source = node;
                }
                ++i;
            }
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> neighborsNodesToD3Format(Collection<Node> nodeEntities, String sourceId, boolean isInitialization, String graphId) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        int i = 0;
        for (Node node : nodeEntities) {
            Point2D point2D = NetworkGraphPositioningHelper.getInstance().addPositions(graphId + node.getId());
            Map nodeMap = node.getX() != 0.0 ? Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor(), "x", point2D.getX(), "y", point2D.getY()}) : Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor()});
            for (NodeProperty property : node.getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            nodeMap.put("value", "0.0");
            nodes.add(nodeMap);
            rels.add(Utils.map((Object[])new Object[]{"source", sourceId, "target", node.getNodeId(), "color", "lightblue", "highlightColor", "blue"}));
        }
        if (isInitialization && rels.size() == 0) {
            Node source = null;
            for (Node node : nodeEntities) {
                if (i > 0) {
                    rels.add(Utils.map((Object[])new Object[]{"source", source.getNodeId(), "target", node.getNodeId(), "color", "transparent", "highlightColor", "transparent"}));
                } else {
                    source = node;
                }
                ++i;
            }
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> dateNodesToD3Format(Collection<DateNode> dateNodesEntities) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        ArrayList<Map> rels = new ArrayList<Map>();
        for (DateNode dateNode : dateNodesEntities) {
            Map nodeMap = Utils.map((Object[])new Object[]{"id", dateNode.getParentId()});
            for (NodeProperty property : dateNode.getParentNode().getNodeProperties()) {
                nodeMap.put(property.getName(), property.getValue());
            }
            nodeMap.put("value", dateNode.getProperty());
            nodes.add(nodeMap);
            rels.add(Utils.map((Object[])new Object[]{"source", dateNode.getParentNode().getNodeId(), "target", dateNode.getHasWeight().getTarget().getParentNode().getNodeId(), "weight", dateNode.getHasWeight().getWeight()}));
        }
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static Map<String, Object> hasWeightToD3Format(Collection<HasWeight> nodeEntities, String graphId, NetworkGraphService networkGraphService, NetworkGraphConfig config) {
        ArrayList<Map> nodes = new ArrayList<Map>();
        HashSet<Map> rels = new HashSet<Map>();
        boolean i = false;
        Iterator<HasWeight> result = nodeEntities.iterator();
        HashMap<String, Node> existedNodes = new HashMap<String, Node>();
        HashMap<String, String> existedLinks = new HashMap<String, String>();
        HashMap<HasWeight, String> targetIds = new HashMap<HasWeight, String>();
        while (result.hasNext()) {
            HasWeight hasWeight = result.next();
            Node node = hasWeight.getSource().getParentNode();
            if (node == null) {
                node = networkGraphService.findNodeById(hasWeight.getSource().getParentId(), graphId);
            }
            if (existedNodes.get(node.getNodeId()) == null) {
                existedNodes.put(hasWeight.getSource().getParentId(), node);
                node.setSize(GraphVisualizationHelper.resizeNode(node, hasWeight));
                node.setColor(GraphVisualizationHelper.getNodeColor(hasWeight, config));
                Point2D point2D = NetworkGraphPositioningHelper.getInstance().addPositions(graphId + node.getId());
                Map nodeMap = node.getX() != 0.0 ? Utils.map((Object[])new Object[]{"id", node.getNodeId(), "value", hasWeight.getSource().getProperty(), "size", node.getSize(), "color", node.getColor(), "x", point2D.getX(), "y", point2D.getY()}) : Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor()});
                for (NodeProperty property : node.getNodeProperties()) {
                    nodeMap.put(property.getName(), property.getValue());
                }
                nodes.add(nodeMap);
            }
            if (existedLinks.get(node.getNodeId() + "," + hasWeight.getTarget().getParentId()) != null) continue;
            existedLinks.put(node.getNodeId() + "," + hasWeight.getTarget().getParentId(), "");
            targetIds.put(hasWeight, hasWeight.getTarget().getProperty());
            rels.add(Utils.map((Object[])new Object[]{"source", node.getNodeId(), "target", hasWeight.getTarget().getParentId(), "weight", hasWeight.getWeight(), "color", "lightblue", "highlightColor", "blue"}));
        }
        targetIds.entrySet().stream().forEach(t -> {
            Node node;
            if (existedNodes.get(t) == null && (node = networkGraphService.findNodeById(((HasWeight)t.getKey()).getTarget().getParentId(), graphId)) != null) {
                node.setSize(GraphVisualizationHelper.resizeNode(node, (HasWeight)t.getKey()));
                node.setColor(GraphVisualizationHelper.getNodeColor((HasWeight)t.getKey(), config));
                Point2D point2D = NetworkGraphPositioningHelper.getInstance().addPositions(graphId + node.getId());
                Map nodeMap = node.getX() != 0.0 ? Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor(), "x", point2D.getX(), "y", point2D.getY()}) : Utils.map((Object[])new Object[]{"id", node.getNodeId(), "size", node.getSize(), "color", node.getColor()});
                for (NodeProperty property : node.getNodeProperties()) {
                    nodeMap.put(property.getName(), property.getValue());
                }
                nodes.add(nodeMap);
            }
        });
        return Utils.map((Object[])new Object[]{"nodes", nodes, "links", rels});
    }

    public static List<String> datesToDateStrings(List<String> dates) {
        List<String> dateStrings = dates.stream().map(date -> {
            StringBuilder sb = new StringBuilder((String)date);
            sb.insert(4, '.');
            return sb.toString();
        }).collect(Collectors.toList());
        return dateStrings;
    }

    public static List<Node> resizeNodesWithLinks(List<TopNodesResult> nodes, NetworkGraphConfig config) {
        List<Node> result = nodes.stream().filter(GraphVisualizationHelper.distinctByKey(node -> node.getNode().getId())).map(node -> {
            node.getNode().setSize(minSize + 3 * node.getLinks());
            if (node.getLinks() < config.getMinNodeLinks()) {
                node.getNode().setColor(config.getMinNodeColor());
            } else if (node.getLinks() > config.getMaxNodeLinks()) {
                node.getNode().setColor(config.getMaxNodeColor());
            } else {
                node.getNode().setColor(config.getMediumNodeColor());
            }
            return node.getNode();
        }).collect(Collectors.toList());
        return result;
    }

    public static int resizeNode(Node node, HasWeight hasWeight) {
        if (hasWeight.getWeight() < 100.0) {
            return (int)(hasWeight.getWeight() * 100.0 + (double)minSize);
        }
        return (int)(hasWeight.getWeight() + (double)minSize);
    }

    public static String getNodeColor(HasWeight hasWeight, NetworkGraphConfig config) {
        if (hasWeight.getWeight() < (double)config.getMinNodeSize()) {
            return config.getMinNodeColor();
        }
        if (hasWeight.getWeight() > (double)config.getMaxNodeSize()) {
            return config.getMaxNodeColor();
        }
        return config.getMediumNodeColor();
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

