/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.helpers;

import gr.uoa.di.aginfra.data.analytics.visualization.model.services.DashBoardService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geojson.Feature;
import org.geojson.FeatureCollection;

public class DashBoardMapConverter {
    public static List<FieldDetails> fieldInfoConvert(Map<String, ?> properties) {
        ArrayList<FieldDetails> fieldDetails = new ArrayList<FieldDetails>();
        properties.forEach((k, v) -> {
            System.out.println("Key : " + k + " Value : " + v);
            FieldDetails fieldDetail = new FieldDetails((String)k, String.valueOf(v));
            fieldDetails.add(fieldDetail);
        });
        return fieldDetails;
    }

    public static List<FieldDetails> FieldDetailsConvert(Map<String, ?> properties) {
        FieldDetails fieldDetail;
        ArrayList<FieldDetails> fieldDetails = new ArrayList<FieldDetails>();
        if (properties.get("soilcode") != null) {
            fieldDetail = new FieldDetails("soilcode", String.valueOf(properties.get("soilcode")));
            fieldDetails.add(fieldDetail);
        }
        if (properties.get("soilname") != null) {
            fieldDetail = new FieldDetails("soilname", String.valueOf(properties.get("soilname")));
            fieldDetails.add(fieldDetail);
        }
        if (properties.get("soiltype") != null) {
            fieldDetail = new FieldDetails("soiltype", String.valueOf(properties.get("soiltype")));
            fieldDetails.add(fieldDetail);
        }
        return fieldDetails;
    }

    public static List<SoilDetails> soilDetailsConvert(String fieldId, List<Feature> features) {
        ArrayList<SoilDetails> soilDetailsList = new ArrayList<SoilDetails>();
        for (Feature feature : features) {
            Map properties = feature.getProperties();
            List props = (List)properties.get("soilunits");
            if (props.size() > 0) {
                LinkedHashMap stringStringLinkedHashMap = (LinkedHashMap)props.get(0);
                SoilDetails soilDetails = new SoilDetails(fieldId, String.valueOf(stringStringLinkedHashMap.get("id")), String.valueOf(stringStringLinkedHashMap.get("soil_code")), String.valueOf(properties.get("area")), String.valueOf(properties.get("perimeter")));
                soilDetailsList.add(soilDetails);
            }
            String string = String.valueOf(properties.get("soilunits"));
        }
        return soilDetailsList;
    }

    public static Soil soilConvert(Feature feature) {
        Map properties = feature.getProperties();
        Soil soil = new Soil(String.valueOf(properties.get("entityid")), String.valueOf(properties.get("soilcode")), String.valueOf(properties.get("soilname")), String.valueOf(properties.get("soiltype")), String.valueOf(properties.get("area")), String.valueOf(properties.get("perimeter")));
        return soil;
    }

    public static List<CropDetails> cropDetailsConvert(List<Feature> features, DashBoardService dashBoardService, String gCubeUrl, Map<String, Object> params) throws Exception {
        ArrayList<CropDetails> cropDetails = new ArrayList<CropDetails>();
        params.remove("geometry");
        for (Feature feature : features) {
            Map properties = feature.getProperties();
            FeatureCollection fieldDetailsFeatureCollection = dashBoardService.getFieldDetails(gCubeUrl + "/" + properties.get("fieldid"), params);
            List<FieldDetails> fieldDetails = DashBoardMapConverter.fieldInfoConvert(((Feature)fieldDetailsFeatureCollection.getFeatures().get(0)).getProperties());
            CropDetails cropDetail = new CropDetails(String.valueOf(properties.get("year")), String.valueOf(properties.get("crop_code")), String.valueOf(properties.get("crop_name")), String.valueOf(properties.get("fieldid")), String.valueOf(fieldDetails.get(3).value), String.valueOf(fieldDetails.get(1).value));
            cropDetails.add(cropDetail);
        }
        cropDetails.sort(Comparator.comparing(CropDetails::getYear));
        return cropDetails;
    }

    public static String getColor(Feature feature) {
        int crop_code = Integer.parseInt(String.valueOf(feature.getProperties().get("crop_code")));
        String grondgebruik = String.valueOf(feature.getProperties().get("grondgebruik"));
        if (crop_code == 256) {
            return "#BC1AE4";
        }
        if (crop_code == 236) {
            return "#FB5599";
        }
        if (crop_code == 252 || crop_code == 253) {
            return "#FF7F00";
        }
        if (crop_code == 259) {
            return "#DBDB30";
        }
        if (crop_code == 233) {
            return "#D55C24";
        }
        if (grondgebruik.equals("Bouwland")) {
            return "#FDF1E3";
        }
        if (grondgebruik.equals("Grasland")) {
            return "#E3ECD4";
        }
        if (grondgebruik.equals("Natuurterrein")) {
            return "#C2E4CC";
        }
        if (grondgebruik.equals("Braakland") || grondgebruik.equals("Overige")) {
            return "#D3D3D3";
        }
        return "#E6C4DC";
    }

    public static class Soil {
        private String entityid;
        private String soilcode;
        private String soilname;
        private String soiltype;
        private String area;
        private String perimeter;

        public Soil() {
        }

        public Soil(String entityid, String soilcode, String soilname, String soiltype, String area, String perimeter) {
            this.entityid = entityid;
            this.soilcode = soilcode;
            this.soilname = soilname;
            this.soiltype = soiltype;
            this.area = area;
            this.perimeter = perimeter;
        }

        public String getEntityid() {
            return this.entityid;
        }

        public void setEntityid(String entityid) {
            this.entityid = entityid;
        }

        public String getSoilcode() {
            return this.soilcode;
        }

        public void setSoilcode(String soilcode) {
            this.soilcode = soilcode;
        }

        public String getSoilname() {
            return this.soilname;
        }

        public void setSoilname(String soilname) {
            this.soilname = soilname;
        }

        public String getSoiltype() {
            return this.soiltype;
        }

        public void setSoiltype(String soiltype) {
            this.soiltype = soiltype;
        }

        public String getArea() {
            return this.area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getPerimeter() {
            return this.perimeter;
        }

        public void setPerimeter(String perimeter) {
            this.perimeter = perimeter;
        }
    }

    public static class SoilDetails {
        private String fieldid;
        private String soilid;
        private String soilcode;
        private String area;
        private String perimeter;
        private Soil soil;

        public SoilDetails() {
        }

        public SoilDetails(String fieldid, String soilid, String soilcode, String area, String perimeter) {
            this.fieldid = fieldid;
            this.soilid = soilid;
            this.soilcode = soilcode;
            this.area = area;
            this.perimeter = perimeter;
        }

        public Soil getSoil() {
            return this.soil;
        }

        public void setSoil(Soil soil) {
            this.soil = soil;
        }

        public String getPerimeter() {
            return this.perimeter;
        }

        public void setPerimeter(String perimeter) {
            this.perimeter = perimeter;
        }

        public String getFieldid() {
            return this.fieldid;
        }

        public void setFieldid(String fieldid) {
            this.fieldid = fieldid;
        }

        public String getSoilid() {
            return this.soilid;
        }

        public void setSoilid(String soilid) {
            this.soilid = soilid;
        }

        public String getSoilcode() {
            return this.soilcode;
        }

        public void setSoilcode(String soilcode) {
            this.soilcode = soilcode;
        }

        public String getArea() {
            return this.area;
        }

        public void setArea(String area) {
            this.area = area;
        }
    }

    public static class CropDetails {
        private String year;
        private String crop_code;
        private String crop_name;
        private String fieldid;
        private String area;
        private String perimeter;

        public CropDetails() {
        }

        public CropDetails(String year, String crop_code, String crop_name, String fieldid, String area, String perimeter) {
            this.year = year;
            this.crop_code = crop_code;
            this.crop_name = crop_name;
            this.fieldid = fieldid;
            this.area = area;
            this.perimeter = perimeter;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getCrop_code() {
            return this.crop_code;
        }

        public void setCrop_code(String crop_code) {
            this.crop_code = crop_code;
        }

        public String getCrop_name() {
            return this.crop_name;
        }

        public void setCrop_name(String crop_name) {
            this.crop_name = crop_name;
        }

        public String getFieldid() {
            return this.fieldid;
        }

        public void setFieldid(String fieldid) {
            this.fieldid = fieldid;
        }

        public String getArea() {
            return this.area;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public String getPerimeter() {
            return this.perimeter;
        }

        public void setPerimeter(String perimeter) {
            this.perimeter = perimeter;
        }
    }

    public static class FieldDetails {
        private String key;
        private String value;

        public FieldDetails() {
        }

        public FieldDetails(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

