/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.definitions;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class DropdownProperties {
    private String text;
    private int key;
    private int value;
    private String unit;

    public DropdownProperties() {
    }

    public DropdownProperties(int key, String text, int value) {
        this.text = text;
        this.key = key;
        this.value = value;
    }

    public DropdownProperties(int key, String text, int value, String unit) {
        this.text = text;
        this.key = key;
        this.value = value;
        ScientificUnit scientificUnit = ScientificUnit.get(unit);
        if (scientificUnit != null) {
            this.unit = scientificUnit.toString();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public static enum ScientificUnit {
        NA("[NA]"),
        Days("Days"),
        NODIM("[-]"),
        NODIM_VOLUME("[volume.volume-1]"),
        NODIM_MASS("[mass.mass-1]"),
        NODIM_AREA("[area.area-1]"),
        NODIM_RADIATION("[radiation energy.radiation energy-1]"),
        PRC("%s"),
        HPA("[hpa]"),
        MBAR("[mbar]"),
        PPM("[ppm]"),
        PPM_Y("[ppm.y-1]"),
        CNT_M2("[no.m-2]"),
        CNT_HA("[no.ha-1]"),
        KG_M2("[kg.m-2]"),
        KG_HA("[kg.ha-1]"),
        KG_KG1D1("[kg.kg-1.d-1]"),
        KG_HA1HR1("[kg.ha-1.hr-1]"),
        HA_HA1D1("[ha.ha-1.d-1]"),
        HA_KG("[ha.kg-1]"),
        CELSIUS("[C]"),
        CELSIUS_DAYS("[C.d]"),
        FAHRENHEIT("[F]"),
        KELVIN("[K]"),
        MJ_M2D1("[mj.m-2.d-1]"),
        KJ_M2D1("[kj.m-2.d-1]"),
        J_M2D1("[j.m-2.d-1]"),
        MM("[mm]"),
        MM_D1("[mm.d-1]"),
        CM("[cm]"),
        CM_D1("[cm.d-1]"),
        M("[m]"),
        M_S("[m.s-1]"),
        M_D1("[m.d-1]"),
        ANGULARDD("[deg]"),
        HOUR("[hr]"),
        DATE("[date]"),
        DATEREL("[Date relative]"),
        DAYS("[d]"),
        PER_DAY("[d-1]"),
        DAYOFYEAR("[doy]"),
        YEAR("[year]"),
        KG_HA1HR1J1_M2S1("[kg.ha-1.hr-1.J-1.m2.s1]");

        private String scientificUnit;
        private static final Map<String, ScientificUnit> lookup;

        private ScientificUnit(String scientificUnit) {
            this.scientificUnit = scientificUnit;
        }

        public String getScientificUnit() {
            return this.scientificUnit;
        }

        public static ScientificUnit get(String scientificUnit) {
            return lookup.get(scientificUnit);
        }

        static {
            lookup = new HashMap<String, ScientificUnit>();
            for (ScientificUnit env : ScientificUnit.values()) {
                lookup.put(env.getScientificUnit(), env);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NodeDto {
        private String id;
        @JsonProperty(value="x")
        private double x;
        @JsonProperty(value="y")
        private double y;
        private Map<String, String> attributes;
        private double size;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public double getSize() {
            return this.size;
        }

        public void setSize(double size) {
            this.size = size;
        }
    }
}

