/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.data;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.CSVImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.FreeMindImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.GraphImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.JsonImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawByteImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporterFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.TreeImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.PropertiesConfig;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RawDataImporterFactoryImpl
implements RawDataImporterFactory {
    private Map<DataType, RawDataImporter> importerMap;

    @Autowired
    public RawDataImporterFactoryImpl(final PropertiesConfig appConfig, final DataDocumentRepository dataDocumentDAO) {
        this.importerMap = new HashMap<DataType, RawDataImporter>(){
            {
                this.put(DataType.Tree, new TreeImporter());
                this.put(DataType.Graph, new GraphImporter());
                this.put(DataType.FreeMind, new FreeMindImporter());
                this.put(DataType.JSON, new JsonImporter(appConfig.getProperties(), dataDocumentDAO));
                this.put(DataType.Records, new CSVImporter(appConfig.getProperties(), dataDocumentDAO));
                this.put(DataType.Image, new RawByteImporter());
            }
        };
    }

    @Override
    public RawDataImporter getImporter(DataType type) throws Exception {
        RawDataImporter importer = this.importerMap.get((Object)type);
        if (importer == null) {
            throw new Exception("Could not find importer for data type " + (Object)((Object)type));
        }
        return importer;
    }
}

