/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.data;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.exceptions.InvalidFormatException;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.CSVReader;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.FileHelpers;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.PropertiesConfig;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.ZipHelpers;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSVImporter
implements RawDataImporter {
    private PropertiesConfig.ApiConfigTemplate config;
    private static final Logger logger = LogManager.getLogger(CSVImporter.class);
    private DataDocumentRepository dataDocumentDAO;

    public CSVImporter(PropertiesConfig.ApiConfigTemplate config, DataDocumentRepository dataDocumentDAO) {
        this.config = config;
        this.dataDocumentDAO = dataDocumentDAO;
    }

    public CSVImporter(DataDocumentRepository dataDocumentDAO) {
        this.config = null;
        this.dataDocumentDAO = dataDocumentDAO;
    }

    @Override
    public void importData(byte[] content, DataDocument dataDocument) throws Exception {
        if (FileHelpers.isZipFile(dataDocument.getName())) {
            this.importZipWithDocuments(content, dataDocument);
        } else {
            this.importPlainCSV(content, dataDocument);
        }
    }

    public void importZipWithDocuments(byte[] content, DataDocument dataDocument) throws Exception {
        String[][] csv;
        String tempDirectory = this.config.getTempDirectory();
        logger.info("Creating directory: " + tempDirectory);
        FileHelpers.createDirectory(tempDirectory);
        logger.info("unzip");
        String unzipedDirectory = ZipHelpers.unzip(content, tempDirectory);
        logger.info("Store images");
        Map<String, String> imagesWithIds = this.storeImages(unzipedDirectory, dataDocument.getVre());
        File csvFile = new File(ZipHelpers.getCSVFile(unzipedDirectory));
        logger.info("csv changes");
        try {
            csv = CSVReader.readCSV(new String(FileHelpers.readBytesFromFile(csvFile.getPath()), StandardCharsets.UTF_8.name()));
            dataDocument.setName(csvFile.getName());
        }
        catch (Exception e) {
            throw new InvalidFormatException("Invalid csv format provided", e);
        }
        if (csv.length < 2) {
            throw new Exception("No records found in csv file");
        }
        dataDocument.setFields(new ArrayList<String>(Arrays.stream(csv[0]).collect(Collectors.toList())));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 1; i < csv.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; j < dataDocument.getFields().size(); ++j) {
                String f = dataDocument.getFields().get(j);
                if (csv[i].length > j) {
                    if (imagesWithIds.containsKey(csv[i][j])) {
                        item.put(f, imagesWithIds.get(csv[i][j]));
                        continue;
                    }
                    item.put(f, csv[i][j]);
                    continue;
                }
                item.put(f, null);
            }
            list.add(item);
        }
        dataDocument.setRecords(list);
        logger.info("delete directory");
        File filesDir = new File(unzipedDirectory);
        try {
            FileUtils.deleteDirectory((File)filesDir);
        }
        catch (NoSuchFileException x) {
            logger.info("%s: no such file or directory%n", (Throwable)x);
        }
        catch (DirectoryNotEmptyException x) {
            logger.info("%s not empty%n", (Throwable)x);
        }
        catch (IOException x) {
            logger.info((Object)x);
        }
    }

    public void importPlainCSV(byte[] content, DataDocument dataDocument) throws Exception {
        String[][] csv;
        try {
            String temp = new String(content, StandardCharsets.UTF_8.name());
            String modContent = "";
            if (!dataDocument.getCommentChar().equals("")) {
                temp = FileHelpers.deleteCommentLine(temp, dataDocument.getCommentChar());
            }
            if (!dataDocument.getDelimiter().equals("")) {
                temp = temp.replace(dataDocument.getDelimiter(), ",");
            }
            System.out.println(temp.substring(0, 10));
            csv = CSVReader.readCSV(temp);
        }
        catch (Exception e) {
            throw new InvalidFormatException("Invalid csv format provided", e);
        }
        if (csv.length < 2) {
            throw new Exception("No records found in csv file");
        }
        dataDocument.setFields(new ArrayList<String>(Arrays.stream(csv[0]).collect(Collectors.toList())));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 1; i < csv.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; j < dataDocument.getFields().size(); ++j) {
                String f = dataDocument.getFields().get(j);
                if (csv[i].length > j) {
                    item.put(f, csv[i][j]);
                    continue;
                }
                item.put(f, null);
            }
            list.add(item);
        }
        dataDocument.setRecords(list);
    }

    private Map<String, String> storeImages(String zipFilePath, String vre) throws Exception {
        File[] files = new File(zipFilePath).listFiles();
        HashMap<String, String> map = new HashMap<String, String>();
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(".png")) continue;
            DataDocument dataDocument = new DataDocument();
            dataDocument.setVre(vre);
            dataDocument.setName(file.getName());
            dataDocument.setType(DataType.Image);
            dataDocument.setDataReference(true);
            dataDocument.setCreatedAt(new Date());
            dataDocument.setUpdatedAt(new Date());
            dataDocument.setRawBytes(FileHelpers.convertImageToBytes(file));
            String id = this.dataDocumentDAO.store(dataDocument);
            map.put(dataDocument.getName(), id);
        }
        return map;
    }
}

