/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.persistence;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.persistence.MongoDataSourceManager;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MongoDataSourceManagerImpl
implements MongoDataSourceManager {
    private static String databaseName = "Visualization";
    private CodecRegistry pojoCodecRegistry;
    private MongoClient mongoClient;

    public MongoDataSourceManagerImpl(@Value(value="${gr.uoa.di.aginfra.data.analytics.visualization.model.persistence.connection}") String databaseURI) {
        this.mongoClient = new MongoClient(new MongoClientURI(databaseURI));
    }

    private MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private CodecRegistry getPojoCodecRegistry() {
        if (this.pojoCodecRegistry == null) {
            this.pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().register(new Class[]{Configuration.class}).register(new Class[]{DataDocument.class}).automatic(true).build()})});
        }
        return this.pojoCodecRegistry;
    }

    @Override
    public MongoDatabase getDataBase() {
        MongoDatabase database = this.getMongoClient().getDatabase(databaseName);
        database = database.withCodecRegistry(this.getPojoCodecRegistry());
        return database;
    }

    @Override
    public GridFSBucket getGridFS() throws Exception {
        MongoDatabase database = this.getMongoClient().getDatabase(databaseName);
        return GridFSBuckets.create((MongoDatabase)database);
    }
}

