/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.data;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.RawDataImporter;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataDocument;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.exceptions.InvalidFormatException;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.CSVReader;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.FileHelpers;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.PropertiesConfig;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.ZipHelpers;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class CSVImporter
implements RawDataImporter {
    private PropertiesConfig.ApiConfigTemplate config;
    private DataDocumentRepository dataDocumentDAO;

    public CSVImporter(PropertiesConfig.ApiConfigTemplate config, DataDocumentRepository dataDocumentDAO) {
        this.config = config;
        this.dataDocumentDAO = dataDocumentDAO;
    }

    @Override
    public void importData(byte[] content, DataDocument dataDocument) throws Exception {
        if (FileHelpers.isZipFile(dataDocument.getName())) {
            this.importZipWithDocuments(content, dataDocument);
        } else {
            this.importPlainCSV(content, dataDocument);
        }
    }

    public void importZipWithDocuments(byte[] content, DataDocument dataDocument) throws Exception {
        String[][] csv;
        String tempDirectory = this.config.getTempDirectory();
        FileHelpers.createDirectory(tempDirectory);
        String unzipedDirectory = ZipHelpers.unzip(content, tempDirectory);
        Map<String, String> imagesWithIds = this.storeImages(unzipedDirectory, dataDocument.getVre());
        File csvFile = new File(ZipHelpers.getCSVFile(unzipedDirectory));
        try {
            csv = CSVReader.readCSV(new String(FileHelpers.readBytesFromFile(csvFile.getPath()), StandardCharsets.UTF_8.name()));
            dataDocument.setName(csvFile.getName());
        }
        catch (Exception e) {
            throw new InvalidFormatException("Invalid csv format provided", e);
        }
        if (csv.length < 2) {
            throw new Exception("No records found in csv file");
        }
        dataDocument.setFields(new ArrayList<String>(Arrays.stream(csv[0]).collect(Collectors.toList())));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 1; i < csv.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; j < dataDocument.getFields().size(); ++j) {
                String f = dataDocument.getFields().get(j);
                if (csv[i].length > j) {
                    if (imagesWithIds.containsKey(csv[i][j])) {
                        item.put(f, imagesWithIds.get(csv[i][j]));
                        continue;
                    }
                    item.put(f, csv[i][j]);
                    continue;
                }
                item.put(f, null);
            }
            list.add(item);
        }
        dataDocument.setRecords(list);
        File filesDir = new File(unzipedDirectory);
        FileUtils.deleteDirectory((File)filesDir);
    }

    public void importPlainCSV(byte[] content, DataDocument dataDocument) throws Exception {
        String[][] csv;
        try {
            csv = CSVReader.readCSV(new String(content, StandardCharsets.UTF_8.name()));
        }
        catch (Exception e) {
            throw new InvalidFormatException("Invalid csv format provided", e);
        }
        if (csv.length < 2) {
            throw new Exception("No records found in csv file");
        }
        dataDocument.setFields(new ArrayList<String>(Arrays.stream(csv[0]).collect(Collectors.toList())));
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 1; i < csv.length; ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            for (int j = 0; j < dataDocument.getFields().size(); ++j) {
                String f = dataDocument.getFields().get(j);
                if (csv[i].length > j) {
                    item.put(f, csv[i][j]);
                    continue;
                }
                item.put(f, null);
            }
            list.add(item);
        }
        dataDocument.setRecords(list);
    }

    private Map<String, String> storeImages(String zipFilePath, String vre) throws Exception {
        File[] files = new File(zipFilePath).listFiles();
        HashMap<String, String> map = new HashMap<String, String>();
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(".png")) continue;
            DataDocument dataDocument = new DataDocument();
            dataDocument.setVre(vre);
            dataDocument.setName(file.getName());
            dataDocument.setType(DataType.Image);
            dataDocument.setDataReference(true);
            dataDocument.setCreatedAt(new Date());
            dataDocument.setUpdatedAt(new Date());
            dataDocument.setRawBytes(FileHelpers.convertImageToBytes(file));
            String id = this.dataDocumentDAO.store(dataDocument);
            map.put(dataDocument.getName(), id);
        }
        return map;
    }
}

