/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators;

import gr.uoa.di.aginfra.data.analytics.visualization.model.services.VisualizationDataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.BarChartDataExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.ThreeDDataExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TimeSeriesExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TupleDataExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.DataSetFilterApplier;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.filters.FilterOptionsExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.BarChartDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.FreeMindDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.GraphDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.JSONDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.ThreeDDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.TimeSeriesDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.TreeDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.TupleDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGeneratorFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class VisualizationDataGeneratorFactoryImpl
implements VisualizationDataGeneratorFactory {
    private ApplicationContext appContext;
    private Map<VisualizationDataType, VisualizationDataGenerator> generatorMap;

    @Autowired
    public VisualizationDataGeneratorFactoryImpl(final ApplicationContext appContext) {
        this.appContext = appContext;
        this.generatorMap = new HashMap<VisualizationDataType, VisualizationDataGenerator>(){
            {
                this.put(VisualizationDataType.BarChart, new BarChartDataGenerator((BarChartDataExtractor)appContext.getBean(BarChartDataExtractor.class), (DataSetFilterApplier)appContext.getBean(DataSetFilterApplier.class), (FilterOptionsExtractor)appContext.getBean(FilterOptionsExtractor.class)));
                this.put(VisualizationDataType.TimeSeries, new TimeSeriesDataGenerator((TimeSeriesExtractor)appContext.getBean(TimeSeriesExtractor.class), (DataSetFilterApplier)appContext.getBean(DataSetFilterApplier.class), (FilterOptionsExtractor)appContext.getBean(FilterOptionsExtractor.class)));
                this.put(VisualizationDataType.ThreeD, new ThreeDDataGenerator((ThreeDDataExtractor)appContext.getBean(ThreeDDataExtractor.class), (DataSetFilterApplier)appContext.getBean(DataSetFilterApplier.class), (FilterOptionsExtractor)appContext.getBean(FilterOptionsExtractor.class)));
                this.put(VisualizationDataType.Tuples, new TupleDataGenerator((TupleDataExtractor)appContext.getBean(TupleDataExtractor.class), (DataSetFilterApplier)appContext.getBean(DataSetFilterApplier.class), (FilterOptionsExtractor)appContext.getBean(FilterOptionsExtractor.class)));
                this.put(VisualizationDataType.FreeMind, new FreeMindDataGenerator());
                this.put(VisualizationDataType.Map, new JSONDataGenerator());
                this.put(VisualizationDataType.Tree, new TreeDataGenerator());
                this.put(VisualizationDataType.Graph, new GraphDataGenerator());
            }
        };
    }

    @Override
    public VisualizationDataGenerator getGenerator(VisualizationDataType visualizationDataType) throws Exception {
        VisualizationDataGenerator generator = this.generatorMap.get((Object)visualizationDataType);
        if (generator == null) {
            throw new Exception("Could not find generator for visualization type " + (Object)((Object)visualizationDataType));
        }
        return generator;
    }
}

