package gr.uoa.di.aginfra.data.analytics.visualization.model.services;

import gr.uoa.di.aginfra.data.analytics.visualization.model.daos.ConfigurationDAO;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractorFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.*;
import gr.uoa.di.aginfra.data.analytics.visualization.model.helpers.VisualizationMapper;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.*;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGenerator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.generators.VisualizationDataGeneratorFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.operations.JoinExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class VisualizationServiceImpl implements VisualizationService {

	private ConfigurationDAO configurationDAO;

	private VisualizationMapper visualizationMapper;

	private DataSetExtractorFactory dataSetExtractorFactory;

	private JoinExecutor joinExecutor;

	private VisualizationDataGeneratorFactory visualizationDataGeneratorFactory;

	@Autowired
	public VisualizationServiceImpl(ConfigurationDAO configurationDAO,
									VisualizationMapper visualizationMapper,
									DataSetExtractorFactory dataSetExtractorFactory,
									JoinExecutor joinExecutor,
									VisualizationDataGeneratorFactory visualizationDataGeneratorFactory) {
		this.configurationDAO = configurationDAO;
		this.visualizationMapper = visualizationMapper;
		this.dataSetExtractorFactory = dataSetExtractorFactory;
		this.joinExecutor = joinExecutor;
		this.visualizationDataGeneratorFactory = visualizationDataGeneratorFactory;
	}

	public Visualization getVisualization(String id) throws Exception {
		return getVisualization(id, null);
	}

	public Visualization getVisualization(String id, Map<String, String> filters) throws Exception {
		Configuration configuration = configurationDAO.GetById(id);

		if (configuration == null) return null;

		Visualization visualization = visualizationMapper.map(configuration);

		visualization.setHasDocuments(configuration.getDocumentField() != null && configuration.getDocumentField().length() > 0);

		loadDataSet(configuration, visualization, filters);

		return visualization;
	}

	private void loadDataSet(Configuration configuration,
							 Visualization visualization,
							 Map<String, String> filters) throws Exception {

		VisualizationDataType dataType = VisualizationDataType.of(visualization.getType());

		DataSet dataSet = extract(configuration, dataType);

		VisualizationDataGenerator generator = visualizationDataGeneratorFactory.getGenerator(dataType);
		generator.generateData(visualization, configuration, dataSet, filters);
	}

	private DataSet extract(Configuration configuration, VisualizationDataType dataType) throws Exception {

		if (configuration.getDataSources().size() == 1) {
			DataSource dataSource = configuration.getDataSources().get(0);

			DataSetExtractor dataSetExtractor = dataSetExtractorFactory.GetExtractor(dataSource);

			return dataSetExtractor.extract(dataSource, dataType);
		} else {
			return joinExecutor.execute(configuration.getDataSources(), configuration.getJoins(), dataType);
		}
	}
}
