/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.Tuple;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TupleDataExtractor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TupleDataExtractorImpl
extends DataSetManipulator
implements TupleDataExtractor {
    @Override
    public Collection<Tuple> extract(DataSet dataSet, String labelField, String valueField) throws Exception {
        int labelFieldIndex = -1;
        if (labelField == null || (labelFieldIndex = this.getFieldIndex(dataSet, labelField)) == -1) {
            throw new Exception("Invalid data field provided " + labelField);
        }
        int valueFieldIndex = -1;
        if (valueField == null || (valueFieldIndex = this.getFieldIndex(dataSet, valueField)) == -1) {
            throw new Exception("Invalid data field provided " + valueField);
        }
        return this.extractData(dataSet, labelFieldIndex, valueFieldIndex);
    }

    private Collection<Tuple> extractData(DataSet dataSet, int labelFieldIndex, int valueFieldIndex) {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (List<String> row : dataSet.getData()) {
            String label = row.get(labelFieldIndex);
            BigDecimal value = this.parseBigDecimal(row.get(valueFieldIndex));
            if (label == null || value == null) continue;
            result.add(new Tuple(label, value));
        }
        return result;
    }
}

