/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.filesystem;

import gr.cite.commons.util.datarepository.DataRepository;
import gr.cite.commons.util.datarepository.UUIDGenerator;
import gr.cite.commons.util.datarepository.elements.FolderInfo;
import gr.cite.commons.util.datarepository.elements.RelativePathAdapter;
import gr.cite.commons.util.datarepository.elements.RepositoryFile;
import gr.cite.commons.util.datarepository.elements.RepositoryRegistry;
import gr.cite.commons.util.datarepository.recovery.DataRepositoryRecoveryFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDataRepository
implements DataRepository {
    private static final Logger log = LoggerFactory.getLogger(FileSystemDataRepository.class);
    private static final String StashFolderName = "stash";
    private static final String sizeThresholdParameterName = "sizeThreshold";
    private static final String shortSweepPeriodParameterName = "shortSweepPeriod";
    private static final String shortSweepPeriodUnitParameterName = "shortSweepPeriodUnit";
    private static final String longSweepPeriodParameterName = "longSweepPeriod";
    private static final String longSweepPeriodUnitParameterName = "longSweepPeriodUnit";
    private static final String recoverParameterName = "recover";
    private static final long sizeThresholdDefault = 1000000000L;
    private static final long shortSweepPeriodDefault = 2L;
    private static final TimeUnit shortSweepPeriodUnitDefault = TimeUnit.HOURS;
    private static final long longSweepPeriodDefault = 5L;
    private static final TimeUnit longSweepPeriodUnitDefault = TimeUnit.HOURS;
    private static final boolean recoverDefault = false;
    private long sizeThreshold = 1000000000L;
    private long shortSweepPeriod = 2L;
    private TimeUnit shortSweepPeriodUnit = shortSweepPeriodUnitDefault;
    private long longSweepPeriod = 5L;
    private TimeUnit longSweepPeriodUnit = longSweepPeriodUnitDefault;
    private boolean recover = false;
    private long lastSweep = new Date().getTime();
    boolean sweeped = false;
    private long sizeReduction = -1L;
    private boolean checkForRecovery = false;
    private ConcurrentHashMap<RepositoryFile, Future<Long>> future = new ConcurrentHashMap();
    private RepositoryRegistry registry = null;
    private File registryFile = null;
    private Marshaller m = null;
    private Unmarshaller um = null;
    private String fileRepositoryPath = null;
    DataRepositoryRecoveryFetcher recoveryFetcher = null;

    @Resource(name="fileRepositoryConfig")
    public void setConfig(Map<String, String> params) throws Exception {
        File stashFolder;
        if (!params.containsKey("fileRepositoryPath")) {
            throw new Exception("No base path found for file data repository");
        }
        this.fileRepositoryPath = params.get("fileRepositoryPath");
        if (params.containsKey(sizeThresholdParameterName)) {
            this.sizeThreshold = Long.parseLong(params.get(sizeThresholdParameterName));
        }
        if (params.containsKey(shortSweepPeriodParameterName)) {
            this.shortSweepPeriod = Long.parseLong(params.get(shortSweepPeriodParameterName));
        }
        if (params.containsKey(shortSweepPeriodUnitParameterName)) {
            this.shortSweepPeriodUnit = TimeUnit.valueOf(params.get(shortSweepPeriodUnitParameterName));
        }
        if (params.containsKey(longSweepPeriodParameterName)) {
            this.longSweepPeriod = Long.parseLong(params.get(longSweepPeriodParameterName));
        }
        if (params.containsKey(longSweepPeriodUnitParameterName)) {
            this.longSweepPeriodUnit = TimeUnit.valueOf(params.get(longSweepPeriodUnitParameterName));
        }
        if (params.containsKey(recoverParameterName)) {
            this.recover = Boolean.valueOf(params.get(recoverParameterName));
        }
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{RepositoryRegistry.class});
        RelativePathAdapter rpa = new RelativePathAdapter(this.fileRepositoryPath);
        this.m = ctx.createMarshaller();
        this.m.setAdapter(RelativePathAdapter.class, (XmlAdapter)rpa);
        this.um = ctx.createUnmarshaller();
        this.um.setAdapter(RelativePathAdapter.class, (XmlAdapter)rpa);
        boolean createdRepositoryFolder = false;
        File rep = new File(this.fileRepositoryPath);
        if (!rep.exists()) {
            rep.mkdir();
            createdRepositoryFolder = true;
        }
        boolean createdRegistry = false;
        this.registryFile = new File(rep, "registry.xml");
        if (!this.registryFile.exists()) {
            createdRegistry = true;
            this.registry = new RepositoryRegistry(this.fileRepositoryPath);
            this.m.marshal((Object)this.registry, this.registryFile);
            this.registryFile.createNewFile();
        }
        if (this.recover && !createdRepositoryFolder && createdRegistry) {
            this.checkForRecovery = true;
        }
        this.registry = (RepositoryRegistry)this.um.unmarshal(this.registryFile);
        this.registry.createLookups();
        if (this.registry.getLastSweep() != null) {
            this.lastSweep = this.registry.getLastSweep();
        }
        if (this.registry.getLastSweepSizeReduction() != null) {
            this.sizeReduction = this.registry.getLastSweepSizeReduction();
        }
        if (!(stashFolder = new File(rep, StashFolderName)).exists()) {
            stashFolder.mkdir();
        }
        if (createdRegistry) {
            this.registry.addFolder(StashFolderName, stashFolder.toURI());
            this.m.marshal((Object)this.registry, this.registryFile);
        }
    }

    @PostConstruct
    private void recoverIfNecessary() {
        if (this.checkForRecovery) {
            try {
                this.recover();
            }
            catch (Exception e) {
                log.error("An error has occurred while recovering from error. Give up.", (Throwable)e);
            }
        }
        this.checkForRecovery = false;
    }

    public void setRecoveryFetcher(DataRepositoryRecoveryFetcher fetcher) {
        this.recoveryFetcher = fetcher;
    }

    public Long getLastSweep() {
        return this.sweeped ? Long.valueOf(this.lastSweep) : null;
    }

    public Long getSweepSizeReduction() {
        return this.sizeReduction != -1L ? Long.valueOf(this.sizeReduction) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() throws Exception {
        HashSet<FolderInfo> toDelete = new HashSet<FolderInfo>();
        HashSet<URI> toDeleteFiles = new HashSet<URI>();
        HashSet<URI> toDeleteFolders = new HashSet<URI>();
        long oldSize = -1L;
        long newSize = -1L;
        long now = new Date().getTime();
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            oldSize = this.registry.getTotalSize();
            if (log.isInfoEnabled()) {
                log.info("File system repository sweep start: Initial repository size= " + this.registry.getTotalSize());
            }
            for (FolderInfo folder : this.registry.getFolderInfo()) {
                ArrayList<String> toDeleteF = new ArrayList<String>();
                for (RepositoryFile file : folder.getFiles()) {
                    if (file.isPermanent() || now - file.getTimestamp() <= TimeUnit.MILLISECONDS.convert(this.longSweepPeriod, this.longSweepPeriodUnit)) continue;
                    if (file.getLocalImage() == null) {
                        throw new Exception("Could not find local file " + file.getId() + " in repository");
                    }
                    if (!file.getLocalImage().getScheme().equals("file")) {
                        throw new Exception("The URI " + file.getLocalImage() + " of local file " + file.getId() + " is not of the correct type");
                    }
                    toDeleteF.add(file.getId());
                    toDeleteFiles.add(file.getLocalImage());
                }
                for (String id : toDeleteF) {
                    this.registry.removeFile(id, folder.getId());
                }
                if (!folder.getFiles().isEmpty() || folder.getUri().toString().endsWith(StashFolderName) || folder.getUri().toString().endsWith("stash/")) continue;
                toDelete.add(folder);
                toDeleteFolders.add(folder.getUri());
            }
            for (FolderInfo d : toDelete) {
                this.registry.removeFolder(d.getId());
            }
            newSize = this.registry.getTotalSize();
            this.lastSweep = new Date().getTime();
            this.sweeped = true;
            this.sizeReduction = oldSize - newSize;
            this.registry.setLastSweep(this.lastSweep);
            this.registry.setLastSweepSizeReduction(this.sizeReduction);
            this.m.marshal((Object)this.registry, this.registryFile);
        }
        for (URI f : toDeleteFiles) {
            new File(f).delete();
        }
        for (URI fol : toDeleteFolders) {
            File[] dirFiles;
            File dir = new File(fol);
            for (File f : dirFiles = dir.listFiles()) {
                f.delete();
            }
            new File(fol).delete();
        }
        if (log.isInfoEnabled()) {
            log.info("File system data repository sweep end: Removed " + toDeleteFiles.size() + " files and " + toDeleteFolders.size() + " directories. Repository size= " + newSize);
        }
    }

    public String persist(RepositoryFile f) throws Exception {
        return this.persistToFolder(f, StashFolderName, true, false);
    }

    public String update(RepositoryFile f) throws Exception {
        return this.updateToFolder(f, StashFolderName);
    }

    public Long close(RepositoryFile file) throws Exception {
        if (!this.future.containsKey(file)) {
            throw new Exception("The file could not be located in pending files");
        }
        Future<Long> f = this.future.get(file);
        long size = 0L;
        try {
            size = f.get();
            file.setSize(size);
            file.markPersisted();
        }
        catch (ExecutionException e) {
            throw e;
        }
        finally {
            this.future.remove(file);
        }
        return new Long(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String persistToFolder(final RepositoryFile f, String folderId, boolean createFile, boolean createFolder) throws Exception {
        if (f.getId() == null) {
            UUID id = UUIDGenerator.randomUUID();
            f.setId(id.toString());
        }
        if (createFolder) {
            folderId = UUIDGenerator.randomUUID().toString();
        }
        File folder = new File(new File(this.fileRepositoryPath), folderId);
        if (!folderId.equals(StashFolderName) && createFolder) {
            folder.mkdir();
        }
        File store = new File(folder, f.getId());
        URI folderUri = folder.toURI();
        if (createFile) {
            store.createNewFile();
            f.setLocalImage(store.toURI());
            f.setTimestamp(new Date().getTime());
        }
        InputStream is = null;
        if (f.getInputStream() != null) {
            is = f.getInputStream();
        } else if (f.getLocalImage() != null) {
            is = f.getLocalImage().toURL().openStream();
        } else {
            throw new Exception("Could not open input stream for file");
        }
        final BufferedInputStream bis = new BufferedInputStream(is);
        final BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(store));
        ExecutorService executor = Executors.newFixedThreadPool(5);
        this.future.put(f, executor.submit(new Callable<Long>(){

            @Override
            public Long call() throws IOException {
                long size = 0L;
                try {
                    byte[] buffer = new byte[1024];
                    int bread = 0;
                    while ((bread = bis.read(buffer)) != -1) {
                        bos.write(buffer, 0, bread);
                        size += (long)bread;
                    }
                }
                catch (IOException io) {
                    Thread.currentThread().interrupt();
                    throw io;
                }
                finally {
                    bis.close();
                    bos.close();
                    f.setInputStream(null);
                    f.markPersisted();
                }
                return size;
            }
        }));
        executor.shutdown();
        if (createFile || createFolder) {
            RepositoryRegistry repositoryRegistry = this.registry;
            synchronized (repositoryRegistry) {
                if (!folderId.equals(StashFolderName) && createFolder) {
                    this.registry.addFolder(folderId, folderUri);
                }
                if (createFile) {
                    this.registry.addFile(f, folderId);
                }
                this.m.marshal((Object)this.registry, this.registryFile);
            }
        }
        long now = new Date().getTime();
        if (this.registry.getTotalSize() > this.sizeThreshold && now - this.lastSweep > TimeUnit.MILLISECONDS.convert(this.shortSweepPeriod, this.shortSweepPeriodUnit) || now - this.lastSweep > TimeUnit.MILLISECONDS.convert(this.longSweepPeriod, this.longSweepPeriodUnit)) {
            this.sweep();
        }
        return f.getId().toString();
    }

    public List<String> listIds() throws Exception {
        return this.registry.listIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryFile retrieve(String id) throws Exception {
        String folderId = null;
        RepositoryFile f = null;
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            folderId = this.registry.lookup(id);
            FolderInfo fi = this.registry.lookupFolder(folderId);
            if (fi == null) {
                return null;
            }
            f = fi.getFile(id);
            if (f == null) {
                return null;
            }
        }
        RepositoryFile ret = new RepositoryFile();
        ret.setLocalImage(f.getLocalImage());
        ret.setDataType(f.getDataType());
        ret.setOriginalName(f.getOriginalName());
        ret.setSize(f.getSize());
        ret.setId(f.getId());
        ret.markPersisted();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateToFolder(List<RepositoryFile> files, String folderId, boolean createFiles, boolean createFolder) throws Exception {
        if (createFolder) {
            folderId = UUIDGenerator.randomUUID().toString();
        }
        File folder = new File(new File(this.fileRepositoryPath), folderId);
        if (createFolder && folder.exists()) {
            throw new Exception("Folder " + folderId + " already exists");
        }
        if (!createFolder && !folder.exists()) {
            throw new Exception("Folder " + folderId + " does not exist");
        }
        URI folderUri = folder.toURI();
        if (createFolder) {
            folder.mkdir();
        }
        boolean updated = false;
        for (RepositoryFile f : files) {
            UUID id = UUIDGenerator.randomUUID();
            File store = null;
            if (createFiles) {
                f.setId(id.toString());
                store = new File(folder, f.getId());
                store.createNewFile();
                f.setLocalImage(store.toURI());
                f.setTimestamp(new Date().getTime());
            } else {
                RepositoryFile ex = null;
                RepositoryRegistry repositoryRegistry = this.registry;
                synchronized (repositoryRegistry) {
                    ex = this.registry.lookupFolder(folderId).getFile(f.getId());
                    ex.setDataType(f.getDataType());
                    ex.setSize(f.getSize());
                    System.out.println("---->" + ex.getSize());
                    ex.setOriginalName(f.getOriginalName());
                    ex.setTimestamp(new Date().getTime());
                    updated = true;
                }
                store = new File(ex.getLocalImage());
            }
            if (!f.hasInputStream()) continue;
            InputStream is = f.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(store));
            try {
                byte[] buffer = new byte[1024];
                int bread = 0;
                while ((bread = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bread);
                }
            }
            finally {
                bis.close();
                bos.close();
                f.markPersisted();
            }
        }
        if (createFolder || createFiles || updated) {
            RepositoryRegistry repositoryRegistry = this.registry;
            synchronized (repositoryRegistry) {
                if (createFolder) {
                    this.registry.addFolder(folderId, folderUri);
                }
                if (createFiles) {
                    for (RepositoryFile f : files) {
                        this.registry.addFile(f, folderId);
                    }
                }
                this.m.marshal((Object)this.registry, this.registryFile);
            }
        }
        long now = new Date().getTime();
        if (this.registry.getTotalSize() > this.sizeThreshold && now - this.lastSweep > TimeUnit.MILLISECONDS.convert(this.shortSweepPeriod, this.shortSweepPeriodUnit) || now - this.lastSweep > TimeUnit.MILLISECONDS.convert(this.longSweepPeriod, this.longSweepPeriodUnit)) {
            this.sweep();
        }
        return folderId;
    }

    public String persistToFolder(List<RepositoryFile> files) throws Exception {
        return this.updateToFolder(files, null, true, true);
    }

    public String updateToFolder(RepositoryFile file, String folderId) throws Exception {
        return this.updateToFolder(Collections.singletonList(file), folderId, false, false);
    }

    public String updateToFolder(List<RepositoryFile> files, String folderId) throws Exception {
        return this.updateToFolder(files, folderId, false, false);
    }

    public String addToFolder(RepositoryFile file, String folderId) throws Exception {
        return this.updateToFolder(Collections.singletonList(file), folderId, false, true);
    }

    public String addToFolder(List<RepositoryFile> files, String folderId) throws Exception {
        return this.updateToFolder(files, folderId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listFolder(String folderId) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            FolderInfo f = this.registry.lookupFolder(folderId);
            if (folderId == null) {
                throw new Exception("Folder " + folderId + " does not exist");
            }
            Set files = f.getFiles();
            for (RepositoryFile file : files) {
                ids.add(file.getId());
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File retrieveFolder(String folderId) throws Exception {
        HashMap<String, String> toRename = new HashMap<String, String>();
        File base = new File(new File(this.fileRepositoryPath), folderId);
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            FolderInfo folderInfo = this.registry.lookupFolder(folderId);
            if (folderInfo == null) {
                return null;
            }
            for (RepositoryFile f : folderInfo.getFiles()) {
                if (f.getLocalImage().toString().equals(f.getOriginalName())) continue;
                f.setLocalImage(new File(base, f.getOriginalName()).toURI());
                toRename.put(f.getId(), f.getOriginalName());
            }
            if (!toRename.isEmpty()) {
                this.m.marshal((Object)this.registry, this.registryFile);
            }
        }
        for (Map.Entry entry : toRename.entrySet()) {
            File oldFile = new File(base, (String)entry.getKey());
            File newFile = new File(base, (String)entry.getValue());
            oldFile.renameTo(newFile);
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) throws Exception {
        String folderId = null;
        URI fileUri = null;
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            folderId = this.registry.lookup(id);
            if (folderId == null) {
                throw new Exception("Could not find a folder containing file " + id);
            }
            FolderInfo fi = this.registry.lookupFolder(folderId);
            RepositoryFile rf = fi.getFile(id);
            fileUri = rf.getLocalImage();
            fi.removeFile(id);
            this.registry.setTotalSize(this.registry.getTotalSize() - rf.getSize());
            this.m.marshal((Object)this.registry, this.registryFile);
        }
        File f = new File(fileUri);
        if (!f.exists()) {
            throw new Exception("Could not locate file " + fileUri);
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalSize() {
        RepositoryRegistry repositoryRegistry = this.registry;
        synchronized (repositoryRegistry) {
            return this.registry.getTotalSize();
        }
    }

    public void recover() throws Exception {
        Map<Object, Object> info = null;
        info = this.recoveryFetcher == null ? new HashMap() : this.recoveryFetcher.fetch();
        long now = new Date().getTime();
        File rep = new File(this.fileRepositoryPath);
        if (!rep.exists()) {
            rep.mkdir();
        }
        this.registryFile = new File(rep, "registry.xml");
        if (!this.registryFile.exists()) {
            this.registry = new RepositoryRegistry(this.fileRepositoryPath);
            this.m.marshal((Object)this.registry, this.registryFile);
            this.registryFile.createNewFile();
        }
        this.registry = (RepositoryRegistry)this.um.unmarshal(this.registryFile);
        this.registry.createLookups();
        Collection existingFiles = FileUtils.listFiles((File)rep, (IOFileFilter)new NotFileFilter((IOFileFilter)new NameFileFilter("registry.xml")), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        for (File existingFile : existingFiles) {
            RepositoryFile fileInfo = (RepositoryFile)info.get(existingFile.getName());
            RepositoryFile rf = new RepositoryFile();
            rf.setId(existingFile.getName());
            rf.setOriginalName(fileInfo != null ? fileInfo.getOriginalName() : existingFile.getName());
            rf.setPermanent(fileInfo != null ? fileInfo.isPermanent() : true);
            rf.setSize(fileInfo != null ? fileInfo.getSize() : existingFile.length());
            rf.setTimestamp(fileInfo != null ? fileInfo.getTimestamp() : now);
            rf.setDataType(fileInfo != null ? fileInfo.getDataType() : "application/octet-stream");
            String folderId = existingFile.toPath().getParent().toString().replace(this.fileRepositoryPath, "").replace(this.fileRepositoryPath.replace("/", "\\"), "");
            if (folderId.startsWith("/") || folderId.startsWith("\\")) {
                folderId = folderId.substring(1);
            }
            File folder = new File(new File(this.fileRepositoryPath), folderId);
            File store = new File(folder, existingFile.getName());
            URI folderUri = folder.toURI();
            rf.setLocalImage(store.toURI());
            if (this.registry.lookupFolder(folderId) == null) {
                this.registry.addFolder(folderId, folderUri);
            }
            if (this.registry.lookup(rf.getId().toString()) != null) continue;
            this.registry.addFile(rf, folderId);
        }
        this.m.marshal((Object)this.registry, this.registryFile);
        this.registry = (RepositoryRegistry)this.um.unmarshal(this.registryFile);
        this.registry.createLookups();
    }

    public Marshaller getMarshaller() {
        return this.m;
    }

    public Unmarshaller getUnmarshaller() {
        return this.um;
    }
}

