$.widget('rdb.CodelistConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		dataModel : null,
		formElementsIdClassNames : {
			dimensinonAttributeDropdown : 'regional-data-collection-data-model-constaints-add-dimension-attribute',
			dimensinonAttributeLoaderContainerClassName : 'regional-data-collection-data-model-constaints-columns-loader-container',
			diplayAndPersistFieldLoaderContainerClassName : 'cls-fields-loader',
			displayFieldId : 'add-modal-codelist-constraint-display-field',
			persistFieldId : 'add-modal-codelist-constraint-persist-field'

		},
		parentEditorElement : null,
		setButtonVisibility : null,
		url : null,
		validator : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log("codelist-constraint");
		this.options.url = 'modules/data-model/add-data-model-details-editors/add-data-model-details-sub-editors/codelist-constraint-editor/codelist-constraint-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
//		this.find('[name="' + this.options.formElementsIdClassNames.dimensinonAttributeDropdown + '"]').rules('remove');
		this.element.html('');
	},
	
	dimensinonAttributeLoader : null,
	
	diplayAndPersistFieldLoaders : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.dimensinonAttributeLoader === null) {
				self.dimensinonAttributeLoader = self.options.config.getInlineSpinner();
				self.dimensinonAttributeLoader.appendTo( self.element.find( '.' + self.options.formElementsIdClassNames.dimensinonAttributeLoaderContainerClassName ) );
			} else self.dimensinonAttributeLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			attribute single select dropdown
			self.element.find('[name="' + self.options.formElementsIdClassNames.dimensinonAttributeDropdown + '"]').html('');

			$.each(columns, function(i,v){
				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo(self.element.find('[name="' + self.options.formElementsIdClassNames.dimensinonAttributeDropdown + '"]'));
			});
			
			self.getCodelistFieldsForDataModel();

			self.isValid();
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.dimensinonAttributeLoader.hide();
		};

		window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getCodelistFieldsForDataModel : function() {
		var self = this;
		
		var url = "getCodelistFieldsForDataModel";
		
		var data = {
				id : dataModelDetails.dataModelID,
				fieldId : self.element.find('[name="' + self.options.formElementsIdClassNames.dimensinonAttributeDropdown + '"]').val()
		};
		
		var bSC = function() {
			self.options.dataModelDetails.clearMessage();
			if(self.diplayAndPersistFieldLoaders === null) {
				self.diplayAndPersistFieldLoaders = self.options.config.getInlineSpinner();
				self.diplayAndPersistFieldLoaders.appendTo( self.element.find( '.' + self.options.formElementsIdClassNames.diplayAndPersistFieldLoaderContainerClassName ) );
			} else self.diplayAndPersistFieldLoaders.show();
		};
		
		var oSC = function(data) {
			var data = $.parseJSON(data.result);
			
			self.element.find('#' + self.options.formElementsIdClassNames.displayFieldId).html('');
			self.element.find('#' + self.options.formElementsIdClassNames.persistFieldId).html('');
			
			$.each(data.fields, function(i,value) {
				var $option = $('<option></option>', {
					text : value,
					value : value
				}).appendTo(self.element.find('#' + self.options.formElementsIdClassNames.displayFieldId));
				
				$option.clone().appendTo(self.element.find('#'+ self.options.formElementsIdClassNames.persistFieldId));
			});
			
			self.options.dataModelDetails.codelistId = data.codelistId;
			self.options.dataModelDetails.codelistLabel = data.codelistLabel;
			self.element.find('#add-modal-codelist-constraint-codelist-label').text(data.codelistLabel);

			self.options.validator.element( self.element.find('#' + self.options.formElementsIdClassNames.displayFieldId) );
			self.options.validator.element( self.element.find('#' + self.options.formElementsIdClassNames.persistFieldId) );
			self.options.setButtonVisibility( 'save-button', self.isValid() );
		};
		
		var oEC = function(jqXHR, exception) {
			self.options.dataModelDetails.errorHandling(jqXHR, exception);
//			Find a way to hide the modal
//			$('#regional-data-collection-data-model-details-add-modal').modal('hide');
		};
		
		var oCC = function() {
			self.element.find( '.' + self.options.formElementsIdClassNames.diplayAndPersistFieldLoaderContainerClassName ).html('');
			self.diplayAndPersistFieldLoaders = null;
		}
		
		self.options.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	getData : function() {
	    var self = this;
		var data = {};
		data.fieldId = this.element.find( '.' + this.options.formElementsIdClassNames.dimensinonAttributeDropdown ).find('option:selected').val().trim();
		data.field = this.element.find( '.' + this.options.formElementsIdClassNames.dimensinonAttributeDropdown ).find('option:selected').text().trim();
		data.codelistId = this.options.dataModelDetails.codelistId;
		data.codelistLabel = this.options.dataModelDetails.codelistLabel;
		data.codelist = this.options.dataModelDetails.codelistLabel;
		data.displayField = this.element.find('#' + self.options.formElementsIdClassNames.displayFieldId).val();
		data.persistField = this.element.find('#' + self.options.formElementsIdClassNames.persistFieldId).val();
		
		return data;
	},
	
	initUIBindings : function() {
		var self = this;
		
		setTimeout(function() {
			self.fillDimensionAttributesDropdown();
		}, 300);
		
		this.element.find( '.' + this.options.formElementsIdClassNames.dimensinonAttributeDropdown ).on('change', function() {
			var constraintTypeOptionValue = self.options.parentEditorElement.find('#regional-data-collection-data-model-constaints-add-constraint-type').val();
			if(constraintTypeOptionValue === self.options.dataModelDetails.constants.CODELIST)
				self.getCodelistFieldsForDataModel();
		});
	},
	
	initValidation : function() {
	    var self = this;

		this.find('[name="' + this.options.formElementsIdClassNames.dimensinonAttributeDropdown + '"]').rules('add', {
			required : true
		});

		this.find('[name="' + this.options.formElementsIdClassNames.displayFieldId + '"]').rules('add', {
            required : true
        });

		this.find('[name="' + this.options.formElementsIdClassNames.persistFieldId + '"]').rules('add', {
            required : true
        });
	},
	
	isValid : function() {
		return this.options.validator.checkForm();
	},
});