/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.portlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PortalUtil;
import gr.cite.bluebridge.endpoint.ServiceProfile;
import gr.cite.regional.data.collection.portlet.BaseController;
import gr.cite.regional.data.collection.portlet.models.UserReference;
import gr.cite.regional.data.collection.portlet.utils.UserProfile;
import gr.cite.regional.data.collection.portlet.web.HttpUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
public class UserController
extends BaseController {
    private static Log _log = LogFactoryUtil.getLog(UserController.class);
    private UserProfile userProfile;

    @ResourceMapping(value="createUserAndDomainIfNotExist")
    public void createUserAndDomainIfNotExist(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Creating User and Domain if they do not exist");
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        scope = pContext.getCurrentScope(httpServletRequest);
        GCubeUser user = pContext.getCurrentUser(httpServletRequest);
        username = user.getUsername();
        this.token = pContext.getCurrentUserToken(scope, username);
        this.singletonHttpClient.setScope(scope);
        this.singletonHttpClient.setToken(this.token);
        this.singletonHttpClient.setUserEmail(user.getEmail());
        this.singletonHttpClient.setUserFullName(user.getFullname());
        this.singletonHttpClient.setUserName(user.getUsername());
        ServiceProfile rdbServiceProfile = this.getRdbServiceProfile();
        List discoveredHosts = this.discoverService(scope, rdbServiceProfile);
        if (discoveredHosts.isEmpty()) {
            throw new ConnectException("No service discovered");
        }
        String discoveredHost = (String)discoveredHosts.get(0);
        this.singletonHttpClient.setHost(discoveredHost);
        this.singletonHttpClient.setScope(scope);
        String serviceUrl = "userReferences/admin/register";
        HashMap headers = new HashMap();
        UserReference ur = new UserReference(user, scope);
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)ur);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="getAllVreUsers")
    public void getAllVreUsers(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting all vre users");
        String serviceUrl = "userReferences";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }
}

