(function() {
	'use strict';

	var ajaxCalls = {
			
			formatDataForAjaxCall : function(data) {
				for(var prop in data) {
					data[this.namespace + prop] = data[prop];
					delete data[prop];
				}
				
				return data;
			},
			
			get : function(theURL, beforeSendCallback, onSuccessCallback, onErrorCallback, onCompleteCallback) {
				$.ajax({
					url: window.config.createResourceURL(theURL),
					type: "get",
					contentType: 'application/json',
					beforeSend: function(xhr) {
						if(typeof beforeSendCallback === 'undefined' || beforeSendCallback === null) return;
						beforeSendCallback(xhr);
					},
					success: function(data) {
						if(typeof onSuccessCallback === 'undefined' || onSuccessCallback === null) return;
						onSuccessCallback(data);
					},
					error : function(jqXHR, textStatus, errorThrown) {
						if(typeof onErrorCallback === 'undefined' || onErrorCallback === null) return;
						onErrorCallback(jqXHR, textStatus, errorThrown);
					},
					complete: function() {
						if(typeof onCompleteCallback === 'undefined' || onCompleteCallback === null) return;
						onCompleteCallback();
					},
				});
			},
			
			namespace : null,
			
			postForm : function(theURL, data, beforeSendCallback, onSuccessCallback, onErrorCallback, onCompleteCallback) {
				$.ajax({
					url: window.config.createResourceURL(theURL),
					type: "post",
					data : data,
					dataType: 'text',
					processData: false,
					contentType: false,
					beforeSend: function(xhr) {
						if(typeof beforeSendCallback === 'undefined' || beforeSendCallback === null) return;
						beforeSendCallback(data);
					},
					success: function(data) {
						if(typeof onSuccessCallback === 'undefined' || onSuccessCallback === null) return;
						onSuccessCallback(data);
					},
					error : function(jqXHR, textStatus, errorThrown) {
						if(typeof onErrorCallback === 'undefined' || onErrorCallback === null) return;
						onErrorCallback(jqXHR, textStatus, errorThrown);
					},
					complete: function() {
						if(typeof onCompleteCallback === 'undefined' || onCompleteCallback === null) return;
						onCompleteCallback();
					},
				});
			},
			
			post : function(theURL, data, beforeSendCallback, onSuccessCallback, onErrorCallback, onCompleteCallback) {
				$.ajax({
					url: window.config.createResourceURL(theURL),
					type: "post",
					data : ajaxCalls.formatDataForAjaxCall(data),
					dataType: 'json',
					beforeSend: function(xhr) {
						if(typeof beforeSendCallback === 'undefined' || beforeSendCallback === null) return;
						beforeSendCallback(xhr);
					},
					success: function(data) {
						if(typeof onSuccessCallback === 'undefined' || onSuccessCallback === null) return;
						onSuccessCallback(data);
					},
					error : function(jqXHR, textStatus, errorThrown) {
						if(typeof onErrorCallback === 'undefined' || onErrorCallback === null) return;
						onErrorCallback(jqXHR, textStatus, errorThrown);
					},
					complete: function() {
						if(typeof onCompleteCallback === 'undefined' || onCompleteCallback === null) return;
						onCompleteCallback();
					},
				});
			},
			
			setNamespace : function(namespace) {
				this.namespace = namespace;
			}
	};

	window.ajaxCalls = ajaxCalls;
})();