$.widget('rdb.AddDataModelDetailsBaseEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		constants : {
			CODELIST : 'codelist',
			DATATYPE_RANGE : "attributeDatatype",
			MANDATORY : 'attributeMandatory',
			CODELIST : 'attributeCodelist',
			NO_DUPLICATES : 'entityNoDuplicates',
			CLSubset : 'tupleCodeListSubset',
			INTEGER : 'integer',
			DECIMAL : 'decimal',
			DATE : 'date'
		},
		dataModelDetails : null,
		defaultCallback : null,
		formValidation : null,
		setButtonVisibility : null,
		subEditorsContainer : null,
		triggerMultiselectId : 'regional-data-collection-data-model-constaints-add-trigger',
		url : null,
		validator : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('AddDataModelDetailsBaseEditor');
		this.options.url = 'modules/data-model/add-data-model-details-editors/add-data-model-details-base-editor/add-data-model-details-base-editor.jsp';
		this.options.callback = function() {
			self.options.subEditorsContainer = self.find('.sub-editors-container');
			self.initUIBindings();
			self.initValidation();
			
			if(self.options.defaultCallback !== null)
				self.options.defaultCallback(self.options.subEditorsContainer, self.options);
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	_getSubEditorData : function() {
		var constraintType = this.constraintTypeDropdown.val();
//		console.log(constraintType);
		
		var subEditorData = {};
		
		switch(constraintType) {
		
		case this.options.constants.MANDATORY :
			subEditorData = this.options.subEditorsContainer.MandatoryConstraintEditor('getData');
			
			break;
		case this.options.constants.NO_DUPLICATES :
			subEditorData = this.options.subEditorsContainer.EntityConstraintNoDuplicates('getData');

			break;
		case this.options.constants.DATATYPE_RANGE :
			subEditorData = this.options.subEditorsContainer.DataTypeRangeConstraintEditor('getData');

			break;
		case this.options.constants.CODELIST :
			subEditorData = this.options.subEditorsContainer.CodelistConstraintEditor('getData');
			
			break;
		case this.options.constants.CLSubset :
			
			break;
		default :
		
		}
		
		return subEditorData;
	},
	
	constraintLabel : null,
	
	constraintTypeDropdown : null,
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getConstraintLabel : function() {
		return this.constraintLabel;
	},
	
	getData : function() {
		var data = {};
		data.label = $('#regional-data-collection-data-model-constaints-add-name').val().trim();
		var constraintName = data.label;
		this.constraintLabel = data.label;
		var constraintType = $('#regional-data-collection-data-model-constaints-add-constraint-type').val().trim();
		data.constraintType = constraintType;//.toLowerCase();
		data.type = data.constraintType.toUpperCase();
		data.errorMessage = $('#regional-data-collection-data-model-constaints-add-error-message').val().trim();
		data.trigger = this.getTrigerMultiSelectDropdownValues();
		//$('#regional-data-collection-data-model-constaints-add-trigger').val();
		
		var subEditorData = this._getSubEditorData();
		
		for(var property in subEditorData) {
			data[property] = subEditorData[property];
		}
		
//		console.log('AddDataModelDetailsBaseEditor');
//		console.log("The data are: ");
//		for(var i in data) {
//			console.log(i + ": " + data[i]);
//		}
		
		return data;
	},
	
	getTrigerMultiSelectDropdownValues : function() {
		var selectedOptions = this.find( '#' + this.options.triggerMultiselectId + ' option:selected');
		var values = [];
		$.each(selectedOptions, function(i,v) {
			values.push($(this).val());
		});
		
		return values;
	},
	
	initializeTrigerMultiSelectDropdown : function() {
	    var self = this;
		this.find( '#' + this.options.triggerMultiselectId ).multiSelect({
            afterSelect: function(values) {
                if(self.options.setButtonVisibility !== null)
                    self.options.setButtonVisibility('save-button', self.isValid());
            },
            afterDeselect: function(values) {
                if(self.options.setButtonVisibility !== null)
                    self.options.setButtonVisibility('save-button', self.isValid());
            }
        });
	},
	
	initUIBindings : function() {
		this.constraintTypeDropdown = this.find('#regional-data-collection-data-model-constaints-add-constraint-type');
		
		var self = this;
		
//		Show hide constraint field on constraint type dropdown change
		this.constraintTypeDropdown.off().on('change', function() {
//			Destroy the widgets initialized on this element
			$.each(self.options.subEditorsContainer.data(), function(i, v) {
				if( typeof self.options.subEditorsContainer.data(i).destroy !== 'undefined' )
					typeof self.options.subEditorsContainer.data(i).destroy();
			});
			
			var constraintTypeOptionValue = $(this).val();
			
			switch(constraintTypeOptionValue) {
			
			case self.options.constants.MANDATORY :
				self.options.subEditorsContainer.MandatoryConstraintEditor(self.options);
				
				break;
			case self.options.constants.NO_DUPLICATES :
				self.options.subEditorsContainer.EntityConstraintNoDuplicates(self.options);

				break;
			case self.options.constants.DATATYPE_RANGE :
				self.options.subEditorsContainer.DataTypeRangeConstraintEditor(self.options);

				break;
			case self.options.constants.CODELIST :
				self.options.subEditorsContainer.CodelistConstraintEditor(self.options);
				
				break;
			case self.options.constants.CLSubset :
				$('.entity-constraints-section').addClass('hidden');
				$('.attribute-constraints-section').addClass('hidden');
				$('.range-related-field').addClass('hidden');
				$('.codelist-related-field').addClass('hidden');
				$('.add-modal-tuple-constraint-codelist-subset-section').removeClass('hidden');
				
			default :
			}
		});
		
		this.initializeTrigerMultiSelectDropdown();
	},
	
	initValidation : function() {
		var self = this;
		
		jQuery.validator.addMethod("atLeastOneTriggeredSelected", function(value, element) {
//			on adding option to multiselect trigger validation
		}, "You must select at least one value");
		
		this.options.validator = this.find('#regional-data-collection-data-model-details-add-modal-constraint-form').validate({
	        onkeyup: function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }

	            if(self.options.setButtonVisibility !== null)
					self.options.setButtonVisibility('save-button', self.isValid());
	        },
	        onfocusout : function (element, event) {
	            if (event.which === 9 && this.elementValue(element) === "") {
	                return;
	            } else {
	                this.element(element);
	            }
	        },
			rules : {
				'regional-data-collection-data-model-constaints-add-name' : {
					required : true
				},
				
				'regional-data-collection-data-model-constaints-add-error-message' : {
					required : true,
				},
				
				'regional-data-collection-data-model-constaints-add-trigger' : {
					required : true
				}
			},
		    highlight : function(element) {
		    	$(element).closest('.control-group').addClass('error');
		    },
		    success : function(label, element) {
			    $(element).closest('.control-group').removeClass('error');
			    label.remove();
		    },
		    errorPlacement : function(error, element) {
		    	error.css('color', 'red');
		    	error.appendTo( element.closest('.controls') );
		    }
		});
		
		this.find('#'+ this.options.triggerMultiselectId).on('change', function() {
			self.options.validator.element('#'+$(this).attr('id'));
		});
	},
	
	isValid : function() {
		return this.options.validator.checkForm();
	},
});