/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.portlet;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import gr.cite.regional.data.collection.portlet.BaseController;
import gr.cite.regional.data.collection.portlet.models.DataSubmission;
import gr.cite.regional.data.collection.portlet.web.HttpUtils;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.ws.rs.core.Response;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
public class DataSubmissionsController
extends BaseController {
    private static Log _log = LogFactoryUtil.getLog(DataSubmissionsController.class);
    private static final int HTTP_CONNECTION_TIMEOUT = 60000;

    @ResourceMapping(value="getDataSubmissions")
    public void getDataSubmissions(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting data submissions");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"collectionId");
        String serviceUrl = "dataCollections/" + id + "/dataSubmissions";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doGet(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="getDataOfDataSubmissions")
    public void getDataOfDataSubmissions(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting data submissions");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        boolean csv = ParamUtil.getBoolean((PortletRequest)request, (String)"csv");
        String serviceUrl = "dataSubmissions/" + id + "/data";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (csv) {
            headers.put("Accept", "text/csv");
        }
        Response clientResponse = !csv ? this.singletonHttpClient.doGet(serviceUrl, headers) : this.singletonHttpClient.doGetCSV(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        byte[] data = result.getBytes();
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="getDataOfDatacolletionAllDataSubmissions")
    public void getDataOfDatacolletionAllDataSubmissions(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting data submissions");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        boolean csv = ParamUtil.getBoolean((PortletRequest)request, (String)"csv");
        String serviceUrl = "dataCollections/" + id + "/dataSubmissions/data";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (csv) {
            headers.put("Accept", "text/csv");
        }
        Response clientResponse = !csv ? this.singletonHttpClient.doGet(serviceUrl, headers) : this.singletonHttpClient.doGetCSV(serviceUrl, headers);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        byte[] data = result.getBytes();
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="importDataCollectionToTabMan")
    public void importDataCollectionToTabMan(ResourceRequest request, ResourceResponse response) throws IOException {
        _log.debug((Object)"Getting data submissions");
        int id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        String serviceUrl = "dataCollections/" + id + "/tabman/import";
        String data = ParamUtil.getString((PortletRequest)request, (String)"data");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("scope", this.singletonHttpClient.getScope());
        headers.put("token", this.singletonHttpClient.getToken());
        byte[] hostBytes = Base64.getEncoder().encode(this.singletonHttpClient.getHost().getBytes());
        String encodedHost = new String(hostBytes, "UTF-8");
        headers.put("discovered_host", encodedHost);
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)data);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        String result = (String)clientResponse.readEntity(String.class);
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }

    @ResourceMapping(value="setDataSubmissionStatus")
    public void setDataSubmissionStatus(ResourceRequest request, ResourceResponse response) {
        _log.debug((Object)"Settting status of DataSubmission");
        Integer id = ParamUtil.getInteger((PortletRequest)request, (String)"id");
        Integer dataSumissionStatus = ParamUtil.getInteger((PortletRequest)request, (String)"dataSumissionStatus");
        DataSubmission ds = new DataSubmission();
        ds.setId(id);
        ds.setStatus(dataSumissionStatus);
        String serviceUrl = "dataSubmissions/" + id + "/status";
        HashMap headers = new HashMap();
        Response clientResponse = this.singletonHttpClient.doPost(serviceUrl, headers, (Object)ds);
        int status = clientResponse.getStatus();
        _log.debug((Object)("Server responded with status: " + status));
        String result = (String)clientResponse.readEntity(String.class);
        JSONObject stateObject = JSONFactoryUtil.createJSONObject();
        stateObject.put("result", result);
        if (status == HttpStatus.OK.value()) {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)stateObject);
        } else if (status == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            HttpUtils.returnResponseAsJson((ResourceResponse)response, (Integer)HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)result);
        } else {
            HttpUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
    }
}

