$.widget('rdb.EditDataModelDetailsBaseEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		constants : {
			CODELIST : 'codelist',
			DATATYPE_RANGE : "attributeDatatype",
			MANDATORY : 'attributeMandatory',
			CODELIST : 'attributeCodelist',
			NO_DUPLICATES : 'entityNoDuplicates',
			CLSubset : 'tupleCodeListSubset',
			INTEGER : 'integer',
			DECIMAL : 'decimal',
			DATE : 'date'
		},
		constraintType : null,
		dataModelDetails : null,
		defaultCallback : null,
		formElementsIdClassNames : {
			name : '#regional-data-collection-data-model-constaints-edit-name',
			errorMessage : '#regional-data-collection-data-model-constaints-edit-error-message',
			constraintType : '#regional-data-collection-data-model-constaints-edit-constraint-type',
			form : '#regional-data-collection-data-model-details-edit-modal-constraint-form'
		},
		setButtonVisibility : null,
		selectedRowConstraintType : null,
		subEditorsContainer : null,
		triggerMultiselectId : '#regional-data-collection-data-model-constaints-edit-trigger',
		url : null,
		validator : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('EditDataModelDetailsBaseEditor');

		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-base-editor/edit-data-model-details-base-editor.jsp';
		this.options.callback = function() {
			self.options.subEditorsContainer = self.element.find('.sub-editors-container');
			self.initUIBindings();
			self.initValidation();
			self.fillFormWithValues();
			
			if(self.options.defaultCallback !== null)
				self.options.defaultCallback(self.options.subEditorsContainer);

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
			    self.turnFormElementsReadonly();
                self.find(self.options.triggerMultiselectId).multiSelect('refresh');
			}
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	_getSubEditorData : function() {
		var constraintType = this.constraintTypeDropdown.val();
		
		var subEditorData = {};
		
		switch(constraintType) {
		
		case this.options.constants.MANDATORY :
			subEditorData = this.options.subEditorsContainer.EditMandatoryConstraintEditor('getData');
			
			break;
		case this.options.constants.NO_DUPLICATES :
			subEditorData = this.options.subEditorsContainer.EditEntityConstraintNoDuplicates('getData');

			break;
		case this.options.constants.DATATYPE_RANGE :
			subEditorData = this.options.subEditorsContainer.EditDataTypeRangeConstraintEditor('getData');

			break;
		case this.options.constants.CODELIST :
			subEditorData = this.options.subEditorsContainer.EditCodelistConstraintEditor('getData');
			
			break;
		case this.options.constants.CLSubset :
			
			break;
		default :
		
		}
		
		return subEditorData;
	},
	
	constraintLabel : null,
	
	constraintTypeDropdown : null,
	
	fillFormWithValues : function () {
		var self = this;
		
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		this.find(this.options.formElementsIdClassNames.name).val(data.label);
		this.find(this.options.formElementsIdClassNames.errorMessage).val(data.errorMessage);
		this.find(this.options.triggerMultiselectId).multiSelect('select', data.trigger);
		var constraintType = data.constraintType;
		if(constraintType.indexOf(this.options.constants.DATATYPE_RANGE) > -1) {
			constraintType = this.options.constants.DATATYPE_RANGE;
		}
		this.find(this.options.formElementsIdClassNames.constraintType).val(constraintType);
		this.loadSubEditorByConstraintTypeValue(constraintType);
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getConstraintLabel : function() {
		return this.constraintLabel;
	},
	
	getData : function() {
		var data = {};
		data.label = this.find(this.options.formElementsIdClassNames.name).val().trim();
		var constraintName = data.label;
		this.constraintLabel = data.label;
		var constraintType = this.find(this.options.formElementsIdClassNames.constraintType).val().trim();
		data.constraintType = constraintType;//.toLowerCase();
		data.type = data.constraintType.toUpperCase();
		data.errorMessage = this.find(this.options.formElementsIdClassNames.errorMessage).val().trim();
		data.trigger = this.getTrigerMultiSelectDropdownValues();
		//$('#regional-data-collection-data-model-constaints-add-trigger').val();
		
		var subEditorData = this._getSubEditorData();
		
//		for(var property in subEditorData) {
//			data[property] = subEditorData[property];
//		}
		Object.assign(data, subEditorData);

//		for(var i in data) {
//			console.log(i + ": " + data[i]);
//		}
		
		return data;
	},
	
	getTrigerMultiSelectDropdownValues : function() {
		var selectedOptions = this.find( this.options.triggerMultiselectId + ' option:selected');
		var values = [];
		$.each(selectedOptions, function(i,v) {
			values.push($(this).val());
		});
		
		return values;
	},
	
	initializeTrigerMultiSelectDropdown : function() {
		this.find( this.options.triggerMultiselectId ).multiSelect();
	},
	
	initUIBindings : function() {
		this.constraintTypeDropdown = this.find('#regional-data-collection-data-model-constaints-edit-constraint-type');
		
		var self = this;
		
//		Show hide constraint field on constraint type dropdown change
		this.constraintTypeDropdown.off().on('change', function() {
//			Destroy the widgets initialized on this element
			$.each(self.options.subEditorsContainer.data(), function(i, v) {
				if( typeof self.options.subEditorsContainer.data(i).destroy !== 'undefined' )
					typeof self.options.subEditorsContainer.data(i).destroy();
			});
			
			var constraintTypeOptionValue = $(this).val();
			
			self.loadSubEditorByConstraintTypeValue(constraintTypeOptionValue);
		});
		
		this.initializeTrigerMultiSelectDropdown();
	},
	
	initValidation : function() {
	    var self = this;
		this.options.validator = this.find(this.options.formElementsIdClassNames.form).validate({
            onkeyup: function (element, event) {
                if (event.which === 9 && this.elementValue(element) === "") {
                    return;
                } else {
                    this.element(element);
                }

                if(self.options.setButtonVisibility !== null)
                    self.options.setButtonVisibility('save-button', self.isValid());
            },
            onfocusout : function (element, event) {
                if (event.which === 9 && this.elementValue(element) === "") {
                    return;
                } else {
                    this.element(element);
                }
            },
            rules : {
                'regional-data-collection-data-model-constaints-edit-name' : {
                    required : true
                },

                'regional-data-collection-data-model-constaints-edit-error-message' : {
                    required : true,
                },

                'regional-data-collection-data-model-constaints-edit-trigger' : {
                    required : true
                }
            },
            highlight : function(element) {
                $(element).closest('.control-group').addClass('error');
            },
            success : function(label, element) {
                $(element).closest('.control-group').removeClass('error');
                label.remove();
            },
            errorPlacement : function(error, element) {
                error.css('color', 'red');
                error.appendTo( element.closest('.controls') );
            }
        });

        this.find(this.options.triggerMultiselectId).on('change', function() {
            self.options.validator.element('#'+$(this).attr('id'));
            self.options.setButtonVisibility('save-button', self.isValid());
        });
	},

	isValid : function() {
	    return this.options.validator.checkForm();
	},
	
	loadSubEditorByConstraintTypeValue : function(constraintTypeOptionValue) {
		this.options.constraintType = constraintTypeOptionValue;
		this.options.selectedRowConstraintType = this.options.dataModelDetails.dataTable.getSelectedRowData().constraintType;
		switch(constraintTypeOptionValue) {
		
		case this.options.constants.MANDATORY :
			this.options.subEditorsContainer.EditMandatoryConstraintEditor(this.options);
			
			break;
		case this.options.constants.NO_DUPLICATES :
			this.options.subEditorsContainer.EditEntityConstraintNoDuplicates(this.options);

			break;
		case this.options.constants.DATATYPE_RANGE :
			this.options.subEditorsContainer.EditDataTypeRangeConstraintEditor(this.options);

			break;
		case this.options.constants.CODELIST :
			this.options.subEditorsContainer.EditCodelistConstraintEditor(this.options);
			
			break;
		case this.options.constants.CLSubset :
			$('.entity-constraints-section').addClass('hidden');
			$('.attribute-constraints-section').addClass('hidden');
			$('.range-related-field').addClass('hidden');
			$('.codelist-related-field').addClass('hidden');
			$('.add-modal-tuple-constraint-codelist-subset-section').removeClass('hidden');
			
		default :
		}
	}
});