(function(){
	"use strict";
	
	var dataCollection = {

	        constants : {
	            exportedToTabman : 'YES',
	            notExportedToTabman : 'NO'
	        },
			
		    clearMessage : function() {
		    	window.notificator.clearMessage(dataCollection.notificator);
		    },
			
			createDataTable : function() {
				$('#regional-data-collection-data-collection-datatable').PortletDataTable({
					ajax : {
				        url : window.config.createResourceURL('getAllDataCollections'),
				        type : 'get',
				        cache : false,
				        dataType : "json",
				        beforeSend : function(xhr) {
				        	
				        },
				        dataSrc : function(data) {
				            dataCollection.enableTabs();

				        	var data = $.parseJSON(data.result);

				        	$.each(data, function(i,v) {
				        		data[i].startDateObject = typeof v.startDate === 'undefined' || v.startDate === null ? window.config.dateMinValue : new Date(v.startDate);
								data[i].endDateObject = typeof v.endDate === 'undefined' || v.endDate === null ? window.config.dateMinValue : new Date(v.endDate);
								
				        		data[i]["startDate"] = typeof v.startDate === 'undefined' || v.startDate === null ? '-' : window.config.formatDate(v.startDate);
								data[i]["endDate"] = typeof v.startDate === 'undefined' || v.endDate === null ? '-' : window.config.formatDate(v.endDate);

								data[i]["exportedToTabman"] = typeof v.tabularResourceId === 'undefined' || v.tabularResourceId === null ? dataCollection.constants.notExportedToTabman : dataCollection.constants.exportedToTabman;
				        	});
				        	
				        	return data;
				        },
				        error : function(jqXHR, exception) {
				        	dataCollection.errorHandling(jqXHR, exception);
				        },
				        complete : function() {

				        },
				        timeout : 20000
					},
					columnDefs : [{
						title : "Label",
						fieldName : 'label',
						targets : 0,
						width : '25%'
					},{
			        	title : "Schema",
			        	fieldName : "dataModel.label",
			            targets : 1,
						width: '25%'
			        }, {
			        	title : "Version",
			        	fieldName : "dataModel.version",
			        	targets : 2
			        }, {
			        	title : "Open From",
			            fieldName : "startDate",
			            targets :  3,
						orderData: 7
			        },  {
			        	title : "Open To",
			            fieldName : "endDate",
			            targets :  4,
						orderData: 8
			        }, {
			            title : "Exported to Tabman",
			            fieldName : 'exportedToTabman',
			            targets : 5
			        }, {
			            fieldName : "startDateObject",
			            visible : false,
						searchable : false,
						orderable : true,
						type : "date"
			        },  {
			            fieldName : "endDateObject",
			            visible : false,
						searchable : false,
						orderable : true,
						type : "date"
			        }],
			        order : [[0, "asc"]],
			    	toolbar : $('#regional-data-collection-data-collection-toolbar')
				});
			    
			    // Get Widget Instance
			    this.dataTable = $('#regional-data-collection-data-collection-datatable').data("dt-PortletDataTable");
			},
			
			dataCollectionContainer : null,

			enableTabs : function() {
                $('.nav.nav-tabs > li:not(.active)').each(function(){
                    $(this).removeClass('disabled');
                });

                $('#regional-data-collection-data-collection-add-button').prop( 'disabled', false );
            },
			
		    errorHandling : function(jqXHR, exception) {
			    window.notificator.errorHandling(dataCollection.notificator, jqXHR, exception);
		    },
			
			getdataCollections : function() {
				this.createDataTable();
			},
			
			init: function($tab, $container) {
//				$tab.one('click', function() {
					dataCollection.dataCollectionContainer = $container;
					dataCollection.loadContent($tab);
//				});
			},
			
			initUIBinding : function() {
				$('#regional-data-collection-data-collection-add-button').off().on('click', function() {
					dataCollection.initWidgetAddDataCollectionModal();
				});
				
				
				$('#regional-data-collection-data-collection-edit-button').on('click', function() {
					dataCollection.initWidgetEditDataCollectionModal();
				});
				
				$('#regional-data-collection-data-collection-remove-button').on('click', function() {
					dataCollection.initWidgetDeleteDataCollectionModal();
				});
			},
			
			initValidation : function() {
				$.getScript(window.config.contextPath + "modules/data-collection/data-collection-form-validation.js")
				.done(function( script, textStatus ) {
					window.dataCollectionFormValidation.init();
				})
				.fail(function( jqxhr, settings, exception ) {
					dataCollection.showMessage("Failed to load validation script", "error");
				});
			},
			
			initWidgetAddDataCollectionModal : function() {
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Save',
						className : 'save-button',
						disabled : true,
						handler : function() {
							var data = {};
							data.dataModelId = $('#regional-data-collection-data-collection-add-form-schema-version').val();
							var label = $('#regional-data-collection-data-collection-add-form-label').val();
							data.label = label;
							data.openFrom = new Date($('#regional-data-collection-data-collection-add-form-open-from-date').val()).getTime().toString();
							data.openTo = new Date($('#regional-data-collection-data-collection-add-form-open-to-date').val()).getTime();
							
							var bSC = undefined;
							var oSC = function() {
								var callback = function() {
									dataCollection.showMessage('Data collection <b>' + label + '</b> was added successfully', "success");
								};
								dataCollection.reloadData(callback);
							};
							var oEC = function(jqXHR, textStatus, errorThrown) { dataCollection.errorHandling(jqXHR, errorThrown); };
							
							window.ajaxCalls.post('addDataCollection', data, bSC, oSC, oEC, null);
						}
				};
				modalButtons.push(buttonProps);
				
				var myModal = $('#regional-data-collection-data-collection-add-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Add data collection',
					modalButtons : modalButtons,
					widgetName : 'DataCollectionAddModal',
					modalWidgetOptions : {
						dataCollection : dataCollection,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							myModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			initWidgetEditDataCollectionModal : function(){
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'OK',
						className : 'save-button',
						disabled : false,
						handler : function() {
							var data = {};
							data.dataModelId = $('#regional-data-collection-data-collection-edit-form-schema-version').val();
							data.label = $('#regional-data-collection-data-collection-edit-form-label').val();
							data.openFrom = new Date($('#regional-data-collection-data-collection-edit-form-open-from-date').val()).getTime().toString();
							data.openTo = new Date($('#regional-data-collection-data-collection-edit-form-open-to-date').val()).getTime();
							data.dataCollectionId = dataCollection.dataTable.getSelectedRowData().id;
							let dataCollectionId = dataCollection.dataTable.getSelectedRowData().id;
							
							var bSC = undefined;
							var oSC = function() {
							    dataCollection.reloadData(function() {
							        dataCollection.showMessage('Data Collection: [' + dataCollectionId + '] was updated successfully', 'success');
							    });
							};
							var oEC = function(jqXHR, textStatus, errorThrown) {
                                dataCollection.showMessage('Update failed for Data Collection: [' + dataCollectionId + ']', 'error');
							};
							
							window.ajaxCalls.post('updateDataCollection', data, bSC, oSC, oEC);
						}
				};
				modalButtons.push(buttonProps);
				
				var editModal = $('#regional-data-collection-data-collection-edit-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Edit data collection',
					modalButtons : modalButtons,
					widgetName : 'DataCollectionEditModal',
					modalWidgetOptions : {
						dataCollection : dataCollection,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							editModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			initWidgetDeleteDataCollectionModal : function() {
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Delete',
						className : 'save-button',
						disabled : false,
						handler : function() {
							var id = self.dataCollection.dataTable.getSelectedRowData().id;
							var dataCollectionLable = self.dataCollection.dataTable.getSelectedRowData().label;
							
							var bSC = function() { self.dataCollection.clearMessage(); };
							var oSC = function() {
								var callback = function() {
									self.dataCollection.showMessage('Data collection <b>' + dataCollectionLable + '</b> deleted successfully', "success");
								};
								self.dataCollection.reloadData(callback);
							};
							var oEC = function(jqXHR, textStatus, errorThrown) { self.dataCollection.errorHandling(jqXHR, errorThrown); };
							var oCC = function() {};
							
							window.ajaxCalls.post("deleteDataCollection", { id : id }, bSC, oSC, oEC, oCC);
						}
				};
				modalButtons.push(buttonProps);
				
				var deleteModal = $('#regional-data-collection-data-collection-remove-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Delete data collection',
					modalButtons : modalButtons,
					widgetName : 'DataCollectionDeleteModal',
					modalWidgetOptions : {
						dataCollection : dataCollection,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							deleteModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			loadContent : function($tab) {
				let $spinner =  window.config.getLoadContentSpinner();
				$spinner.insertBefore(dataCollection.dataCollectionContainer);
				this.dataCollectionContainer.load(window.config.contextPath + "modules/data-collection/data-collection.jsp", function() {
					$spinner.remove();
					dataCollection.notificator = $("#regional-data-collection-data-collections-notificator");
					dataCollection.spinner = dataCollection.dataCollectionContainer.find(".spinner");
					
					dataCollection.initUIBinding();
					dataCollection.getdataCollections();

                    $tab.on('shown', function() {
                        dataCollection.reloadData(function(){});
                    });
				});
			},
			
			notificator : null,
			
			reloadData : function(callback) {
				if(typeof callback === 'undefined') {
					dataCollection.dataTable.refreshData(dataCollection.clearMessage);
				} else {
					dataCollection.dataTable.refreshData(callback);
				}
				
			},
			
		    showMessage : function(text, type) {
			    window.notificator.setText(dataCollection.notificator, text, type);
		    },
			
			spinner : null
	};
	
	window.dataCollection = dataCollection;
})();