$.widget('rdc.DateRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		formElementsIdClassNames : {
		    integerDecimalInputMin : 'regional-data-collection-data-model-constaints-add-min-date-value',
		    integerDecimalInputMax : 'regional-data-collection-data-model-constaints-add-max-date-value'
		},
		setButtonVisibility : null,
		url : null,
		validator : null
	},

	_create : function() {
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('DateRangeConstraintEditor');
		var self = this;
		
		this.options.url = 'modules/data-model/add-data-model-details-editors/add-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-subeditors/datatype-range-constraint-date-editor/datatype-range-constraint-date-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
        this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMin + '"]').rules('remove');
        this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMax + '"]').rules('remove');
		this.element.html('');
	},

	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.min = new Date(this.element.find('#regional-data-collection-data-model-constaints-add-min-date-value').val()).getTime();
		data.max = new Date(this.element.find('#regional-data-collection-data-model-constaints-add-max-date-value').val()).getTime();
		
		return data;
	},
	
	initUIBindings : function() {
		
	},
	
	initValidation : function() {
	    var self = this;

        jQuery.validator.addMethod("minDateLesserThanMaxDateInAddConstraintForm", function(value, element) {
			var minDate = $(element).val();
			var maxDate = self.find('[name="' + self.options.formElementsIdClassNames.integerDecimalInputMax + '"]').val();
			if(maxDate.length === 0) return true;
			else return new Date(minDate) < new Date(maxDate);
		}, "Must be lesser than the Max Value");

		jQuery.validator.addMethod("maxDateLesserThanMinDateInAddConstraintForm", function(value, element) {
			var maxDate = $(element).val();
			var minDate = self.find('[name="' + self.options.formElementsIdClassNames.integerDecimalInputMin + '"]').val();
			if(minDate.length === 0) return true;
			else return new Date(minDate) < new Date(maxDate);
		}, "Must be greater than the Min Value");

        this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMin + '"]').rules('add', {
			date : true,
			minDateLesserThanMaxDateInAddConstraintForm : true
		});

		this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMax + '"]').rules('add', {
            date : true,
            maxDateLesserThanMinDateInAddConstraintForm : true
        });

        this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMin + '"]').on('change', function() {
            self.options.validator.element($(this));
            self.options.validator.element( self.find('[name="' + self.options.formElementsIdClassNames.integerDecimalInputMax + '"]') );
            self.options.setButtonVisibility( 'save-button', self.isValid() );
        });

        this.find('[name="' + this.options.formElementsIdClassNames.integerDecimalInputMax + '"]').on('change', function() {
            self.options.validator.element($(this));
            self.options.validator.element( self.find('[name="' + self.options.formElementsIdClassNames.integerDecimalInputMin + '"]') );
            self.options.setButtonVisibility( 'save-button', self.isValid() );
        });

        self.options.setButtonVisibility( 'save-button', self.isValid() );
	},

    isValid : function() {
        return this.options.validator.checkForm();
    }
	
});