(function() {
	'use strict';

	var dataModel = {

			createDataTable : function() {
				// Create datatable
				$('#regional-data-collection-data-model-datatable').PortletDataTable({
					ajax :	{
						url : window.config.createResourceURL('getAllDataModels'),
			            type : "GET",
			            cache : false,
			            dataType : "json",
						beforeSend : function(xhr) {
							dataModel.clearMessage();
						},
						dataSrc : function(data) {
							return $.parseJSON(data.result);
						},
						error : function(jqXHR, exception) {
							dataModel.errorHandling(jqXHR, exception);
						},
						complete : function() {
//							dataSubmission.globalCompleteCallback();
						},
						timeout : 20000
					},
					columnDefs : [{
						title : "Schema",
						fieldName : "label",
						targets : 0,
						width: '25%'
					}, {
						title : "Version",
						fieldName : "version",
						targets : 1
					}, {
						title : "URI",
						fieldName : "uri",
						targets :  2,
						width: '55%'
					}],
					order : [[0, "asc"]],
					toolbar : $('#regional-data-collection-data-model-toolbar'),
					onRowSelectionCallback : function() {
						dataModel.dataModelContainer.find('#regional-data-collection-data-model-delete-button').attr('disabled', dataModel.dataTable.getSelectedRowData().activeDataCollectionPeriod);
					},
					onRowDeSelectionCallback : function() {
					    dataModel.dataModelContainer.find('#regional-data-collection-data-model-delete-button').attr('disabled', true);
					}
				});

				// Get Widget Instance
				this.dataTable = $('#regional-data-collection-data-model-datatable').data("dt-PortletDataTable");
			},

			dataModelContainer : null,

			getdataModels : function() {
				this.createDataTable();
			},

			init : function($element, $container) {
				this.dataModelContainer = $container;

				$element.one('click', function() {
					dataModel.loadContent($element);
					dataModel.loadCSS();
				});
			},
			
			initDeleteDataModelWidget : function() {
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Delete',
						className : 'save-button',
						disabled : false,
						handler : function() {
							var modelID = dataModel.dataTable.getSelectedRowData().id;
							var modelName = dataModel.dataTable.getSelectedRowData().label;
							
							var url = 'deleteDataModel';
							
							var bSC = function() { dataModel.clearMessage(); };
							
							var oSC = function(data) {
								var callback = function() {
									dataModel.showMessage("Data model <b>" + modelName + "</b> deleted successfully", "success");
								};								
								dataModel.reloadData(callback);
							};
							
							var oEC = function(jqXHR, textStatus, errorThrown) {
								if(jqXHR.status === 404) {
									dataModel.showMessage("Data model <b>" + modelName + "</b> not found", "error");
									return;
								}
								
//								dataModel.showMessage(jqXHR.responseText, "error");
								dataModel.errorHandling(jqXHR, errorThrown);
							};
							
							var data = {};
							data["id"] = modelID;
							
							window.ajaxCalls.post(url, data, bSC, oSC, oEC);
						}
				};
				modalButtons.push(buttonProps);
				
				var deleteDataModelModal = $('#regional-data-collection-data-model-delete-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Delete data model',
					modalButtons : modalButtons,
					widgetName : 'DeleteDataModelEditor',
					modalWidgetOptions : {
						dataModel : dataModel,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							deleteDataModelModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			initImportDataModelWidget : function() {
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Save',
						className : 'save-button',
						disabled : true,
						handler : function() {
							let $spinner;
							var theURL = 'importDSD';

							var bSC = function(xhr) {
								dataModel.clearMessage();
								
								$spinner = window.config.getPageSpinner();
								$spinner.insertBefore(dataModel.dataModelContainer);
							};

							var oSC = function(data) {
								var obj = $.parseJSON(data);
								
								var callback = function(){
									dataModel.showMessage("Data model <b>" + obj.result+ "</b> imported successfully", "success");
								};
								dataModel.reloadData(callback);
							};

							var oEC = function(jqXHR, textStatus, errorThrown) {
								dataModel.errorHandling(jqXHR, errorThrown);
							};

							var oCC = function() { $spinner.remove(); };

							var formData = new FormData();
							
							var dataModelImport = {};
							dataModelImport.name = $.trim($('#regional-data-collection-data-model-import-form-name').val());
							dataModelImport.version = $.trim($('#regional-data-collection-data-model-import-form-version').val());
							dataModelImport.uri = $.trim($('#regional-data-collection-data-model-import-form-uri').val());

							var dataModelXMLFile = $('#regional-data-collection-data-model-import-form-file').prop('files')[0];
						
							formData.append('dataModelXMLFile', dataModelXMLFile);
							formData.append('dataModelImport', JSON.stringify(dataModelImport));
							
							window.ajaxCalls.postForm(theURL, formData, bSC, oSC, oEC, oCC);
						}
				};
				modalButtons.push(buttonProps);
				
				var importDataModelModal = $('#regional-data-collection-data-model-import-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Import data model(DSD)',
					modalButtons : modalButtons,
					widgetName : 'ImportDataModelEditor',
					modalWidgetOptions : {
						dataModel : dataModel,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							importDataModelModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},

			initUIBindings : function() {
				$('#regional-data-collection-data-model-import-button').on('click', function() {
					dataModel.initImportDataModelWidget();
				});
				
				$('#regional-data-collection-data-model-edit-button').one('click', function() {
					dataModel.dataModelContainer.addClass('hidden');
					
					window.dataModelDetails.init($('#regional-data-collection-data-models-details-container'), dataModel.dataTable.getSelectedRowData());
					
					$('#regional-data-collection-data-model-edit-button').off().on('click', function() {
						dataModel.dataModelContainer.addClass('hidden');

						window.dataModelDetails.setDataModelData(dataModel.dataTable.getSelectedRowData());

						window.dataModelDetails.dataModelDetailsContainer.removeClass('hidden');
						
						$('#regional-data-collection-data-model-details-constraint-title').text(dataModel.dataTable.getSelectedRowData().label + ' constraints');
						
						window.dataModelDetails.setdataModelID(dataModel.dataTable.getSelectedRowData().id);
						window.dataModelDetails.setdataModelName(dataModel.dataTable.getSelectedRowData().label);
						window.dataModelDetails.reloadStaticColumns();
						window.dataModelDetails.reloadData(function(){});
					});
					
				});
				
				$('#regional-data-collection-data-model-delete-button').on('click', function() {
					dataModel.initDeleteDataModelWidget();
				});
			},
			
			initValidation : function() {
				$.getScript(window.config.contextPath + "modules/data-model/data-model-form-validation.js")
				.done(function( script, textStatus ) {
					window.dataModelFormValidation.init();
				})
				.fail(function( jqxhr, settings, exception ) {
					dataModel.showMessage("Failed to laod validation script", "error");
				});
			},

			loadContent : function($element) {
				let $spinner =  window.config.getLoadContentSpinner();
				$spinner.insertBefore(this.dataModelContainer);
				this.dataModelContainer.load(window.config.contextPath + "modules/data-model/data-model.jsp", function() {
					$spinner.remove();
					dataModel.notificator = $("#regional-data-collection-data-models-notificator");
					dataModel.spinner = dataModel.dataModelContainer.find(".spinner");

					dataModel.initUIBindings();
					dataModel.getdataModels();

                    $element.on('shown',function() {
                        dataModel.reloadData(function(){});
                    });
				});
			},
			
			loadCSS : function() {
				 $("<link/>", {
				        rel : "stylesheet",
				        type : "text/css",
				        href : window.config.contextPath + "modules/data-model/data-model.css"
				    }).appendTo("head");
			},
			
			reloadData : function(callback) {
				if(typeof callback === 'undefined') {
					dataModel.dataTable.refreshData(dataModel.clearMessage);
				} else {
					dataModel.dataTable.refreshData(callback);
				}

                dataModel.dataModelContainer.find('#regional-data-collection-data-model-delete-button').attr('disabled', true);
			},
			
			showMessage : function(text, type) {
				window.notificator.setText(dataModel.notificator, text, type);
			},
			
		    clearMessage : function() {
			    window.notificator.clearMessage(dataModel.notificator);
		    },
		    
		    errorHandling : function(jqXHR, exception) {
			    window.notificator.errorHandling(dataModel.notificator, jqXHR, exception);
		    },
	};

	window.dataModel = dataModel;
})();