$.widget('rdb.IntegerRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		dataModelDetails : null,
		decimal : null,
		formElementsIdClassNames : {
		    minIntDecimal : 'regional-data-collection-data-model-constaints-add-min-integer-decimal-value',
		    maxIntDecimal : 'regional-data-collection-data-model-constaints-add-max-integer-decimal-value'
		},
		integer : null,
		setButtonVisibility : null,
		url : null
	},
	
	_create : function() {
	    if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('IntegerRangeConstraintEditor');
		var self = this;
		
		this.options.url = 'modules/data-model/add-data-model-details-editors/add-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-subeditors/datatype-range-constraint-integer-editor/datatype-range-constraint-integer-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
        this.find('[name="' + this.options.formElementsIdClassNames.minIntDecimal + '"]').rules("remove" );
        this.find('[name="' + this.options.formElementsIdClassNames.maxIntDecimal + '"]').rules("remove" );
		this.element.html('');
	},

	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.min = this.element.find('#' + this.options.formElementsIdClassNames.minIntDecimal).val();
		data.max = this.element.find('#' + this.options.formElementsIdClassNames.maxIntDecimal).val();
		
		return data;
	},
	
	initUIBindings : function() {
		
	},
	
	initValidation : function() {
	    var self = this;

	    jQuery.validator.addMethod("minIntLesserThanMaxDateInAddConstraintForm", function(value, element) {
            var minValue = $(element).val();
            var maxValue = self.find('[name="' + self.options.formElementsIdClassNames.maxIntDecimal + '"]').val();
            if( minValue.length === 0 && maxValue.length === 0 ) return true;
            else if( minValue.length !== 0 && maxValue.length === 0 || minValue.length === 0 && maxValue.length !== 0 ) return false;
            else return Number(minValue) < Number(maxValue);
        }, "Must be lesser than the Max Value");

        jQuery.validator.addMethod("maxIntLesserThanMinDateInAddConstraintForm", function(value, element) {
            var maxValue = $(element).val();
            var minValue = self.find('[name="' + self.options.formElementsIdClassNames.minIntDecimal + '"]').val();
            if( minValue.length === 0 && maxValue.length === 0 ) return true;
            else if( minValue.length !== 0 && maxValue.length === 0 || minValue.length === 0 && maxValue.length !== 0 ) return false;
            else return Number(minValue) < new Number(maxValue);
        }, "Must be greater than the Min Value");

        jQuery.validator.addMethod("integerValue", function(value, element) {
            var maxValue = $(element).val();
            if(maxValue.length > 0 && maxValue.charAt( maxValue.length - 1) === '.' ) return false;
            var num = Number( maxValue );

            if( isNaN( num ) ) {
                return false;
            } else {
                return num === parseInt( num, 10 );
            }
        }, "Please enter only integers");


        if( self.options.integer === true ) {
            this.find('[name="' + this.options.formElementsIdClassNames.minIntDecimal + '"]').rules('add', {
                integerValue: true,
                minIntLesserThanMaxDateInAddConstraintForm : true
            });

            this.find('[name="' + this.options.formElementsIdClassNames.maxIntDecimal + '"]').rules('add', {
                integerValue: true,
                maxIntLesserThanMinDateInAddConstraintForm : true
            });
        } else if( self.options.decimal === true ) {
            this.find('[name="' + this.options.formElementsIdClassNames.minIntDecimal + '"]').rules('add', {
                number: true,//number = decimal
                minIntLesserThanMaxDateInAddConstraintForm : true
            });

            this.find('[name="' + this.options.formElementsIdClassNames.maxIntDecimal + '"]').rules('add', {
                number: true,//number = decimal
                maxIntLesserThanMinDateInAddConstraintForm : true
            });
        }

		this.find('#'+this.options.formElementsIdClassNames.minIntDecimal).keyup(function() {
            self.options.validator.element('#' + self.options.formElementsIdClassNames.maxIntDecimal);
        });

        this.find('#' + this.options.formElementsIdClassNames.maxIntDecimal).keyup(function() {
            self.options.validator.element('#' + self.options.formElementsIdClassNames.minIntDecimal);
        });

        self.options.setButtonVisibility( 'save-button', self.isValid() );
	},

	isValid : function() {
	    return this.options.validator.checkForm();
	}
});