(function() {
	'use strict';
	
	var dataCollectionFormValidation = {
			init : function() {
				this.initAddDataCollectionForm();
				this.initEditDataCollectionForm();
			},
			
			initAddDataCollectionForm : function() {
				jQuery.validator.addMethod("fromToDateLesserThanToDateInAddDataCollectionForm", function(value, element) {
					var dateFromStr = $(element).val();
					var dateToStr = $('#regional-data-collection-data-collection-add-form-open-to-date').val();
					if(dateToStr.length === 0) return true;
					else return new Date(dateFromStr) < new Date(dateToStr);
				}, "Must be lesser than the Open to date");
				
				jQuery.validator.addMethod("toDateLesserThanFromDateInAddDataCollectionForm", function(value, element) {
					var dateToStr = $(element).val();
					var dateFromStr = $('#regional-data-collection-data-collection-add-form-open-from-date').val();
					if(dateFromStr.length === 0) return true;
					else return new Date(dateFromStr) < new Date(dateToStr);
				}, "Must be greater than the Open from date");

				$('#regional-data-collection-data-model-add-form').validate({
			        onkeyup: function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			            
			            var valid = $(event.target).closest("form").validate().checkForm();
						$('#regional-data-collection-data-collection-add-modal-save').attr("disabled", !valid);
			        },
			        onfocusout : function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			        },
					rules : {
						'regional-data-collection-data-collection-add-form-label' : {
							required : true
						},
						
						'regional-data-collection-data-collection-add-form-open-from-date' : {
							required : true,
							date : true,
							fromToDateLesserThanToDateInAddDataCollectionForm : true
						},
						
						'regional-data-collection-data-collection-add-form-open-to-date' : {
							required : true,
							date : true,
							toDateLesserThanFromDateInAddDataCollectionForm : true
						}
					},
				    highlight : function(element) {
				    	$(element).closest('.control-group').addClass('error');
				    },
				    success : function(label, element) {
					    $(element).closest('.control-group').removeClass('error');
					    label.remove();
				    },
				    errorPlacement : function(error, element) {
				    	error.css('color', 'red');
				    	error.appendTo( element.closest('.controls') );
				    }
				});
				
				$('#regional-data-collection-data-model-add-form input[type=date]')
				.on('change', function() {
					$('#regional-data-collection-data-model-add-form input[type=date]').each(function(index, value) {
						if($(this).val() !== '')
							$(this).closest("form").validate().element(this);
					});
					
					var valid = $(this).closest("form").validate().checkForm();
					$('#regional-data-collection-data-collection-add-modal-save').attr("disabled", !valid);
				});
			},
			
			initEditDataCollectionForm : function() {
				jQuery.validator.addMethod("fromToDateLesserThanToDateInEditDataCollectionForm", function(value, element) {
					var dateFromStr = $(element).val();
					var dateToStr = $('#regional-data-collection-data-collection-edit-form-open-to-date').val();
					if(dateToStr.length === 0) return true;
					else return new Date(dateFromStr) < new Date(dateToStr);
				}, "Must be lesser than the Open to date");
				
				jQuery.validator.addMethod("toDateLesserThanFromDateInEditDataCollectionForm", function(value, element) {
					var dateToStr = $(element).val();
					var dateFromStr = $('#regional-data-collection-data-collection-edit-form-open-from-date').val();
					if(dateFromStr.length === 0) return true;
					else return new Date(dateFromStr) < new Date(dateToStr);
				}, "Must be greater than the Open from date");

				$('#regional-data-collection-data-model-edit-form').validate({
			        onkeyup: function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			            
			            var valid = $(event.target).closest("form").validate().checkForm();
						$('#regional-data-collection-data-collection-edit-modal-save').attr("disabled", !valid);
			        },
			        onfocusout : function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			        },
					rules : {
						'regional-data-collection-data-collection-edit-form-label' : {
							required : true
						},
						
						'regional-data-collection-data-collection-edit-form-open-from-date' : {
							required : true,
							date : true,
							fromToDateLesserThanToDateInEditDataCollectionForm : true
						},
						
						'regional-data-collection-data-collection-edit-form-open-to-date' : {
							required : true,
							date : true,
							toDateLesserThanFromDateInEditDataCollectionForm : true
						}
					},
				    highlight : function(element) {
				    	$(element).closest('.control-group').addClass('error');
				    },
				    success : function(label, element) {
					    $(element).closest('.control-group').removeClass('error');
					    label.remove();
				    },
				    errorPlacement : function(error, element) {
				    	error.css('color', 'red');
				    	error.appendTo( element.closest('.controls') );
				    }
				});
				
				$('#regional-data-collection-data-model-edit-form input[type=date]')
				.on('change', function() {
					$(this).closest("form").validate().element(this);
					
					$('#regional-data-collection-data-model-edit-form input[type=date]').each(function(index, value) {
						if($(this).val() !== '')
							$(this).closest("form").validate().element(this);
					});
					
					var valid = $(this).closest("form").validate().checkForm();
					$('#regional-data-collection-data-collection-edit-modal-save').attr("disabled", !valid);
				});
			},
			
			validateEditDataCollectionForm : function() {
				$('#regional-data-collection-data-model-edit-form').validate().form();
			}
	};
	
	window.dataCollectionFormValidation = dataCollectionFormValidation;
})();