(function(){
	'use strict';
	
	var dataSubmission = {
			
			options : {
				inlineSpinnerContainerClassName : 'spinner-container',
				dataSubmissionStatusType : {
					TEMPORARY : 0,
					INVITATION_TO_SUBMIT : 1,
					SUBMITTED_FOR_CHECK : 2,
					VALIDATED : 3,
					REJECTED : 4,
					WITHDRAWN_ENTRY : 5
				},
				entityType : {
				    DATACOLLECTION : 1,
				    DATASUBMISSION : 2
				}
			},
			
			addOnTabShownCallback : function() {
				this.tab.on('shown', function(e) {
					dataSubmission.getDataCollections();
				});
			},
			
			approveDataSubmission : function() {
				this.setDataSubmissionStatus(dataSubmission.options.dataSubmissionStatusType.VALIDATED);
			},
			
			cdtModalContainer : null,
			
			clearMessage : function() {
				window.notificator.clearMessage(dataSubmission.notificator);
			},
			
			collectionId : null,

			collectionName : null,
			
			createDataTable : function() {
				// Create datatable
				$('#regional-data-collection-data-submission-datatable').PortletDataTable({
					onInitDtCallback : function() {
//			    		dataSubmission.addOnTabShownCallback();
					},
					ajax :	{
						url : window.config.createResourceURL('getDataSubmissions'),
						type : 'POST',
						cache : false,
						dataType : "json",
						data : function() {
							return window.ajaxCalls.formatDataForAjaxCall({ collectionId : dataSubmission.collectionId });
						},
						beforeSend : function(xhr) {
                                $('#regional-data-collection-data-submission-export-all-button')[0].disabled = true;
								$('#regional-data-collection-data-submission-import-to-tabman-button')[0].disabled = true;
								$('#regional-data-collection-data-submission-view-all-button')[0].disabled = true;
						},
						dataSrc : function(data) {
							var data = $.parseJSON(data.result);

							$.each(data, function(i,v) {
//				        		Dates
								data[i].submissionDateObject = typeof v.submissionTimestamp === 'undefined' || v.submissionTimestamp === null ? window.config.dateMinValue : new Date(v.submissionTimestamp);
								data[i].completionDateObject = typeof v.completionTimestamp === 'undefined' || v.completionTimestamp === null ? window.config.dateMinValue : new Date(v.completionTimestamp);
								
								data[i]["submittedAt"] = typeof v.submissionTimestamp === 'undefined' || v.submissionTimestamp === null ? '-' : window.config.formatDate(v.submissionTimestamp);
								data[i]["completedAt"] = typeof v.completionTimestamp === 'undefined' || v.completionTimestamp === null ? '-' : window.config.formatDate(v.completionTimestamp);
								
//								Status
								data[i]["statusAsString"] = dataSubmission.statusToText(data[i].status);
							});

							return data;
						},
						error : function(jqXHR, exception) {
							dataSubmission.errorHandling(jqXHR, exception);
						},
						complete : function() {
							if(dataSubmission.dataTable.dataTable.data().length === 0) {
								$('#regional-data-collection-data-submission-export-all-button')[0].disabled = true;
								$('#regional-data-collection-data-submission-import-to-tabman-button')[0].disabled = true;
								$('#regional-data-collection-data-submission-view-all-button')[0].disabled = true;
							} else {
								$('#regional-data-collection-data-submission-export-all-button')[0].disabled = false;
								$('#regional-data-collection-data-submission-import-to-tabman-button')[0].disabled = false;
								$('#regional-data-collection-data-submission-view-all-button')[0].disabled = false;
							}
						},
						timeout : 20000
					},
					columnDefs : [{
						title : "Author",
						fieldName : "attributes.metadata.author",//attributes.metadata.author
						targets : 0
					}, {
						title : "Status",
						fieldName : "statusAsString",
						targets : 1
					}, {
						title : "Submitted At",
						fieldName : "submittedAt",
						targets :  2,
						orderData: 5
					},  {
						title : "Completed At",
						fieldName : "completedAt",
						targets :  3,
						orderData: 6
					}, {
						fieldName : "submissionDateObject",
						visible : false,
						searchable : false,
						orderable : true,
						type : "date"
					},  {
						fieldName : "completionDateObject",
						visible : false,
						searchable : false,
						orderable : true,
						type : "date"
					}/*,  {
						title : "Notes",
						fieldName : "comment",
						targets :  4
					}*/],
					order : [[0, "asc"]],
					toolbar : $('#regional-data-collection-data-submission-toolbar')
				});

				// Get Widget Instance
				this.dataTable = $('#regional-data-collection-data-submission-datatable').data("dt-PortletDataTable");
			},

			dataCollectionsDropdown : null,

			dataSubmissionContainer : null,
			
			dataTable : null,

			disableDataSubmissionPage : function() {
			    this.dataSubmissionContainer.css('pointer-events', 'none');
			    this.dataSubmissionContainer.css('opacity', '0.8');
			},

			disableTabs : function() {
			//tabs are disabled using css, see view.jsp
//			    $('.nav.nav-tabs li:not(.active)').each(function(){
//                    $(this).css('pointer-events','none');
//                });
			},

			enableDataSubmissionPage : function() {
			    this.dataSubmissionContainer.css('pointer-events', 'auto');
                this.dataSubmissionContainer.css('opacity', '1');
			},

			enableTabs : function() {
                $('.nav.nav-tabs > li:not(.active)').each(function(){
                    $(this).removeClass('disabled');
                });
			},
			
			errorHandling : function(jqXHR, exception) {
				window.notificator.errorHandling(dataSubmission.notificator, jqXHR, exception);
			},

			exportAllDatSubmissionsDataInCsvFormat : function() {
				if( this.dataCollectionsDropdown.find('option').length === 0 ) {
					dataSubmission.showMessage('No data collection available','error');
					return;
				}
				var url = 'getDataOfDatacolletionAllDataSubmissions';
				var data = {
						id : dataSubmission.dataCollectionsDropdown.val(),
						csv : true
				};

				var bSC = function(){};
				var oSC = function(data){
					var csvContent = data.result;

					var filename = dataSubmission.collectionName + "_" + dataSubmission.collectionId + '.csv';
					var type = 'text/csv';
						var blob = new Blob([ csvContent ], {
							type : type
						});
						var URL = window.URL || window.webkitURL;
						var downloadUrl = URL.createObjectURL(blob);

						if (typeof window.navigator.msSaveBlob !== 'undefined') {
							window.navigator.msSaveBlob(blob, filename);
						} else {
							var URL = window.URL || window.webkitURL;
							var downloadUrl = URL.createObjectURL(blob);

							if (filename) {
								var a = document.createElement("a");
								if (typeof a.download === 'undefined') {
									window.location = downloadUrl;
								} else {
									a.href = downloadUrl;
									a.download = filename;
									document.body.appendChild(a);
									a.click();
								}
							} else {
								window.location = downloadUrl;
							}

							setTimeout(function() {
								URL.revokeObjectURL(downloadUrl);
							}, 100); // cleanup
						}
				};

				var oEC = function(jqXHR, textStatus, errorThrown) {
					dataSubmission.errorHandling(jqXHR, errorThrown);
				};

				window.ajaxCalls.post(url, data, bSC, oSC, oEC);
			},

			exportDataInCsvFormat : function() {
				var url = 'getDataOfDataSubmissions';
				var data = {
						id : dataSubmission.dataTable.getSelectedRowData().id,
						csv : true
				};
				
				var bSC = function(){};
				var oSC = function(data){
					var csvContent = data.result;

					var filename = 'DataSubmission_'+ dataSubmission.dataTable.getSelectedRowData().id + '.csv';
					var type = 'text/csv';
                    var blob = new Blob([ csvContent ], {
                        type : type
                    });
                    var URL = window.URL || window.webkitURL;
                    var downloadUrl = URL.createObjectURL(blob);

                    if (typeof window.navigator.msSaveBlob !== 'undefined') {
                        window.navigator.msSaveBlob(blob, filename);
                    } else {
                        var URL = window.URL || window.webkitURL;
                        var downloadUrl = URL.createObjectURL(blob);

                        if (filename) {
                            var a = document.createElement("a");
                            if (typeof a.download === 'undefined') {
                                window.location = downloadUrl;
                            } else {
                                a.href = downloadUrl;
                                a.download = filename;
                                document.body.appendChild(a);
                                a.click();
                            }
                        } else {
                            window.location = downloadUrl;
                        }

                        setTimeout(function() {
                            URL.revokeObjectURL(downloadUrl);
                        }, 100); // cleanup
                    }
				};

				var oEC = function(jqXHR, textStatus, errorThrown) {
					dataSubmission.errorHandling(jqXHR, errorThrown);
				};

				window.ajaxCalls.post(url, data, bSC, oSC, oEC);
			},
			
			getAnchorForCSVDownload : function() {
				return $('<a></a>', {
//					href : 'data:application/octet-stream,',
					href : "data:text/csv;charset=utf-8,",
					id : 'regional-data-collection-data-submission-download-as-csv',
					download : '.csv',
					css : {
						display : 'none'
					}
				});
			},

			getDataCollectionEndDate : function() {
			    return new Date( dataSubmission.dataCollectionsDropdown.find('option:selected').data('end') );
			},

			getDataCollectionStartDate : function() {
			    return new Date( dataSubmission.dataCollectionsDropdown.find('option:selected').data('start') );
			},
			
			getDataCollections : function() {
				var url = 'getAllDataCollections';
				
				var bSC = function() {
                    if( dataSubmission.initialized === false )
                        dataSubmission.disableTabs();

                    if ( dataSubmission.dataTable !== null ) dataSubmission.disableDataSubmissionPage();

					if(dataSubmission.inlineSpinner === null) {
						dataSubmission.inlineSpinner = window.config.getInlineSpinner();
						dataSubmission.dataSubmissionContainer.find('.' + dataSubmission.options.inlineSpinnerContainerClassName).append(dataSubmission.inlineSpinner);
					} else dataSubmission.inlineSpinner.show();
				};
				
				var oSC = function(data) {
				    if ( dataSubmission.dataTable !== null ) dataSubmission.enableDataSubmissionPage();

				    dataSubmission.initialized = true;
				    dataSubmission.enableTabs();

					var data = $.parseJSON($.parseJSON(data).result);
					data.sort(function(obj1, obj2) {
						var label1 = obj1.label.toUpperCase();
						var label2 = obj2.label.toUpperCase();
						
						if(label1 < label2) {
							return -1;
						} else if (label1 > label2) {
							return 1;
						} else return 0;
					});
					
					let dataCollectionIDs = []
					
					dataSubmission.dataCollectionsDropdown.html('');
					$.each(data, function(i,v) {
						
						dataCollectionIDs.push(data[i].id);

						let exportedToTabmanMessage = ( typeof data[i].tabularResourceId === 'undefined' || data[i].tabularResourceId === null ) ? dataCollection.constants.notExportedToTabman : dataCollection.constants.exportedToTabman;

						$('<option></option>', {
							text : data[i].label,
							value : data[i].id,
							'data-start' : data[i].startDate,
							'data-end' : data[i].endDate,
							'data-is-exported-to-tabman' : exportedToTabmanMessage
						})
						.appendTo(dataSubmission.dataCollectionsDropdown);
					});

					dataSubmission.initUIBindingDataCollectionDropdown();
					
					if( dataSubmission.collectionId === null && dataCollectionIDs.length > 0 )
						dataSubmission.setDataCollectionDetails();
					else if( dataSubmission.collectionId !== null && dataCollectionIDs.indexOf(Number(dataSubmission.collectionId)) > -1 )
						dataSubmission.dataCollectionsDropdown.val(dataSubmission.collectionId);//this will trigger the reload
					else if( dataSubmission.collectionId === null && dataCollectionIDs.indexOf( Number( dataSubmission.collectionId ) ) === -1 ) {
						if(dataSubmission.dataTable === null) return;
						else dataSubmission.dataTable.dataTable.clear().draw();
					} else if( dataSubmission.collectionId !== null && dataCollectionIDs.indexOf( Number( dataSubmission.collectionId ) ) === -1 )
						dataSubmission.dataTable.dataTable.clear().draw();
					
					if(dataSubmission.dataTable === null) 
						dataSubmission.getDataSubmissions();
					else dataSubmission.reloadDataTable();
				};
				
				var oEC = function(jqXHR, textStatus, errorThrown) {
					dataSubmission.errorHandling(jqXHR, errorThrown);
				};
				
				var oCC = function() {
					dataSubmission.inlineSpinner.hide();
				};
				
				window.ajaxCalls.get(url, bSC, oSC, oEC, oCC);
			},
			
			getDataSubmissions : function() {
				dataSubmission.createDataTable();
			},

			getEol: function() {
				var aPlatform = navigator.platform.toLowerCase();
				if(aPlatform.indexOf('win') != -1) return "\r\n"; // win
				else if(aPlatform.indexOf('mac') != -1) return "\r"; // mac
				else if(aPlatform.indexOf('unix') != -1
					 || aPlatform.indexOf('linux') != -1
					 || aPlatform.indexOf('sun') != -1) return "\n"; // nix
			},

			importDataCollectionToTabMan : function() {
			    let $spinner;
				var url = 'importDataCollectionToTabMan';
				var data = {id : dataSubmission.dataCollectionsDropdown.val()};
				var bSC = function(){
				    $spinner = window.config.getPageSpinner();
				    $spinner.insertBefore(dataSubmission.dataSubmissionContainer);
				};
				var oSC = function(data){
					dataSubmission.showMessage(data.result,"success");
				};
				var oEC = function(jqXHR, textStatus, errorThrown) {
					dataSubmission.errorHandling(jqXHR, errorThrown);
				};
                var oCC = function() { $spinner.remove(); };

				window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
			},
			
			init : function($tab, $container) {
				this.dataSubmissionContainer = $container;
				this.tab = $tab;
				this.tab.one('click', function() {
				    dataSubmission.loadContent();
				});
			},

			initialized : false,

			initCdtWidget : function( entityType, text ) {
			    var modalHeaderText, url, id, modalCss;
			    let attributes;
			    modalCss = {
                    width : '80%',
                    'margin-left' : '10%',
                    left : 0
                };
                if ( entityType === dataSubmission.options.entityType.DATACOLLECTION ) {
                    modalHeaderText = text + ' details';
                    url = 'getDataOfDatacolletionAllDataSubmissions';
                    id = dataSubmission.collectionId;

                } else if ( entityType === dataSubmission.options.entityType.DATASUBMISSION ) {
                    modalHeaderText = 'Data submission details';
                    url = 'getDataOfDataSubmissions';
                    id = dataSubmission.dataTable.getSelectedRowData().id;
                    attributes = dataSubmission.dataTable.getSelectedRowData().attributes;
                    if( attributes !== null
                        && !$.isEmptyObject(attributes)
                        && attributes.metadata
                        && !$.isEmptyObject( attributes.metadata )
                        && Object.entries( attributes .metadata ).length > 7 ) {

                        modalCss = {
                            width : '98%',
                            'margin-left' : '1%',
                            left : 0
                        };

                    }
                }

			    var cdtModal = dataSubmission.cdtModalContainer.ModalWidget({
                    ajaxCall : window.ajaxCalls,
                    config : window.config,
                    dataSubmission : dataSubmission,
                    entityType : entityType,
                    modalHeaderText : modalHeaderText,
                    modalButtons : [],
                    modalCss : modalCss,
                    widgetName : 'ViewCdtEditor',
                    modalWidgetOptions : {
                        dataSubmission : dataSubmission,
                        ajaxCalls : window.ajaxCalls,
                        config : window.config,
                        entityType : entityType,
                        portletDataTableWidgetName : 'PortletDataTable',
                        portletDataTableWidgetOptions : {

                        },
                        portletDataWidgetLoadHeadersCallback : function($cdtDataTable, callback) {
// Initalize empty data-table and showProcessing, otherwise the dataTable appears only after the ajax call ends
                            $cdtDataTable.PortletDataTable({
                                checkBox : false,
                                columnDefs : [{title : ""}],
                                data : [],
                                order : [[0, "asc"]]
                            });

                            $cdtDataTable.PortletDataTable('showProcessing');

                            var data = {
                                id : id
                            };
                            var bSC = function(){};
                            var oSC = function(data){
                                var headers = $.parseJSON(data.result).headers;
                                var serverData = $.parseJSON(data.result).data;

                                var columnDefs = [];
                                $.each(headers, function(index,value) {
                                    columnDefs.push({
                                        title : value,
                                        fieldName : value,
                                        targets : index
                                    });
                                });

                                var cdtData = [];
                                $.each(serverData, function(i,v) {
                                    var datum = {};
                                    for(var property in v.data) {
                                        datum[property] = v.data[property];
                                    }

                                    for(var prop in v) {
                                        if(prop === 'data')continue;
                                        datum[prop] = v[prop];
                                    }

                                    cdtData.push(datum);
                                });



                                $cdtDataTable.PortletDataTable('destroyDataTable');

                                $cdtDataTable.PortletDataTable({
                                    checkBox : false,
                                    columnDefs : columnDefs,
                                    data : [],
                                    order : [[0, "asc"]]
                                });

                                $cdtDataTable.data("dt-PortletDataTable").showProcessing();
//
                                setTimeout(function() {
                                    $cdtDataTable.DataTable().rows.add( cdtData );

                                    //workaround to show paging buttons
                                    $cdtDataTable.DataTable().draw();

                                    $cdtDataTable.data("dt-PortletDataTable").hideProcessing();

                                }, 250);

//                                let attributes = dataSubmission.dataTable.getSelectedRowData().attributes;
                                if( typeof callback !== 'undefined' && callback !== null )
                                    callback( dataSubmission.collectionIsExportedToTabman, attributes );
                            };
                            var oEC = function(jqXHR, textStatus, errorThrown) {
                                dataSubmission.errorHandling(jqXHR, errorThrown);
                                cdtModal.ModalWidget('hide');

                                $cdtDataTable.data("dt-PortletDataTable").hideProcessing();
                            };

                            window.ajaxCalls.post(url, data, bSC, oSC, oEC);
                        },
                        setButtonVisibility : function(name, visible) {
                            cdtModal.ModalWidget('setButtonVisibility', name, visible);
                        }
                    }
                });
			},
			
			initUIBindings : function() {
				this.cdtModalContainer = $('#regional-data-collection-cdt-modal-container');
				
				$('#regional-data-collection-data-submission-approve-button').off().on('click', function() {
					dataSubmission.approveDataSubmission();
				});
				
				$('#regional-data-collection-data-submission-reject-button').off().on('click', function() {
					dataSubmission.rejectDataSubmission();
				});
				
				$('#regional-data-collection-data-submission-export-button').off().on('click', function() {
					dataSubmission.exportDataInCsvFormat();
				});

				$('#regional-data-collection-data-submission-export-all-button').off().on('click', function() {
					dataSubmission.exportAllDatSubmissionsDataInCsvFormat();
				});

//				$('#regional-data-collection-data-submission-import-selected-to-tabman-button').off().on('click', function() {
//				    dataSubmission.initWidgetExportSelectedDataSubmissionToTabmanModal();
//				});

				$('#regional-data-collection-data-submission-import-to-tabman-button').off().on('click', function() {
                    dataSubmission.initWidgetExportToTabmanModal(false);
				});
				
				$('#regional-data-collection-data-submission-view-button').off().on('click', function() {
					dataSubmission.initCdtWidget( dataSubmission.options.entityType.DATASUBMISSION );
				});

				$('#regional-data-collection-data-submission-view-all-button').off().on('click', function() {
                    dataSubmission.initCdtWidget( dataSubmission.options.entityType.DATACOLLECTION, dataSubmission.collectionName );
				});

			},
			
			initUIBindingDataCollectionDropdown : function() {
				this.dataCollectionsDropdown.off().on('change', function(e) {
					dataSubmission.setDataCollectionDetails();
					dataSubmission.reloadDataTable();
				});
			},

			initWidgetExportSelectedDataSubmissionToTabmanModal : function() {
                if( dataSubmission.dataTable.getSelectedRowData().status !== dataSubmission.options.dataSubmissionStatusType.VALIDATED )
                    dataSubmission.showMessage("Please, check the status of the selected submission. Only validated submissions are exported to Tabman", 'error');
                else dataSubmission.initWidgetExportToTabmanModal(true);
			},

			initWidgetExportToTabmanModal : function(isSubmission) {

                var myModal = $('#regional-data-submision-export-to-tabman-modal-container').ModalWidget({
                    ajaxCall : window.ajaxCalls,
                    config : window.config,
                    modalHeaderText : 'Export to TabMan',
                    modalButtons : [],
                    widgetName : 'TabmanEditor',
                    modalWidgetOptions : {
                        dataSubmission : dataSubmission,
                        ajaxCalls : window.ajaxCalls,
                        config : window.config,
                        isSubmission : isSubmission,
                        setButtonVisibility : function(name, visible) {
                            myModal.ModalWidget('setButtonVisibility', name, visible);
                        }
                    }
                });

                var modalButtons = [];
                var buttonProps = {
                        dismissModal : true,
                        label : 'Save',
                        className : 'save-button',
                        disabled : true,
                        handler : function() {
                            var modalBody = myModal.ModalWidget('getModalBody');
                            var widget = myModal.ModalWidget('option', 'widgetName');
                            modalBody[widget]('submitForm');
                        }
                };
                modalButtons.push(buttonProps);
                myModal.ModalWidget('option', 'modalButtons', modalButtons);

			},
			
			inlineSpinner : null,
			
			loadContent : function() {
				let $spinner =  window.config.getLoadContentSpinner();
				$spinner.insertBefore(this.dataSubmissionContainer);
				this.dataSubmissionContainer.load(window.config.contextPath + "modules/data-submission/data-submission.jsp", function() {
					$spinner.remove();
					dataSubmission.notificator = $("#regional-data-collection-data-submissions-notificator");
					dataSubmission.spinner = dataSubmission.dataSubmissionContainer.find(".spinner");
					
					dataSubmission.setDataCollectionDropdown($('#regional-data-collection-data-submissions-dropdown'));
					dataSubmission.getDataCollections();
					dataSubmission.initUIBindings();
					dataSubmission.addOnTabShownCallback();
				});
			},
			
			loadCSS : function() {
				$("<link/>", {
					rel : "stylesheet",
					type : "text/css",
					href : window.config.contextPath + "modules/data-submission/data-submission.css"
				}).appendTo("head");
			},
			
			notificator: null,
			
			rejectDataSubmission : function() {
				this.setDataSubmissionStatus(dataSubmission.options.dataSubmissionStatusType.REJECTED);
			},
			
			reloadDataTable : function(callback) {
				if(typeof callback === 'undefined') {
					dataSubmission.dataTable.refreshData(dataSubmission.clearMessage);
				} else {
					dataSubmission.dataTable.refreshData(callback);
				}
			},

			setDataCollectionDetails : function() {
                dataSubmission.collectionId = this.dataCollectionsDropdown.val();
                dataSubmission.collectionName = this.dataCollectionsDropdown.find('option:selected').text();
                dataSubmission.collectionIsExportedToTabman = this.dataCollectionsDropdown.find('option:selected').data('is-exported-to-tabman');
			},
			
			setDataCollectionDropdown : function(element) {
				this.dataCollectionsDropdown = element;
			},
			
			setDataSubmissionStatus : function(status) {
				var data = {
						id : dataSubmission.dataTable.getSelectedRowData().id,
						dataSumissionStatus : status
				};
				var oEC = function(jqXHR, textStatus, errorThrown) {
					dataSubmission.errorHandling(jqXHR, errorThrown);
				};
				window.ajaxCalls.post("setDataSubmissionStatus", data, null, function(){dataSubmission.reloadDataTable()}, oEC, null);
			},
			
			showMessage : function(text, type) {
				window.notificator.setText(dataSubmission.notificator, text, type);
			},

			statusToText : function(status) {
				let statusTypes = this.options.dataSubmissionStatusType;
				let text='unknown';
				for(let property in statusTypes) {
					if(Number(status) === statusTypes[property]) {
						text = property;
						break;
					}
				}

				return text;
			}
	};
	
	window.dataSubmission = dataSubmission;
})();