$.widget('rdb.EditDataTypeRangeConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		constraintType : null,
		dimensionAttributeLoadeContainer : 'regional-data-collection-data-model-constaints-columns-loader-container',
		dataModelDetails : null,
		formElementsIdClassNames : {
			dimensionAttribute : '#regional-data-collection-data-model-constaints-edit-dimension-attribute',
			rangeType : '#regional-data-collection-data-model-constaints-edit-range-constraint-datatype'
		},
		myConstraintType : 'attributeDatatype',
		rangeType : null,
		setButtonVisibility : null,
		selectedRowConstraintType : null,
		url : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log("EditDataTypeRangeConstraintEditor");
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/datatype-range-constraint-editor/datatype-range-constraint-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
                self.turnFormElementsReadonly();
            }
		};
		
		this._super();
	},
	
	_destroy : function() {
		this.element.html('');
	},
	
	dimensionAttributeLoader : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.dimensionAttributeLoader === null) {
				self.dimensionAttributeLoader = self.options.config.getInlineSpinner();
				self.dimensionAttributeLoader.appendTo( self.find( '.' + self.options.dimensionAttributeLoadeContainer ) );
			} else self.dimensionAttributeLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			attribute single select dropdown
			var $dropdown = self.find(self.options.formElementsIdClassNames.dimensionAttribute);
			$dropdown.html('');

			$.each(columns, function(i,v){
				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo($dropdown);
			});
			
			if( self.options.selectedRowConstraintType.indexOf(self.options.myConstraintType) > -1 ) {
				self.fillFormWithValues();

			    let fieldId = $dropdown.val();

				self.loadSubEditorsByRangeType(self.options.rangeType, fieldId);
			}
			else self.initDefaultRangeDataType();
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.dimensionAttributeLoader.hide();
		};

		window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	fillFormWithValues : function() {
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		let $dropDown = this.find(this.options.formElementsIdClassNames.dimensionAttribute);

		let $rangeTypeDropdown = this.find(this.options.formElementsIdClassNames.rangeType);

//		if( data.fieldId !== $dropDown.val() ) return;

		$rangeTypeDropdown.val(data.datatype);
		$dropDown.val(data.fieldId);

		this.options.rangeType = $rangeTypeDropdown.val();
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var self = this;
		var data = {};
		
		data.datatype = this.find(this.options.formElementsIdClassNames.rangeType).val();
		data.fieldId = this.find(this.options.formElementsIdClassNames.dimensionAttribute + ' option:selected').val().trim();
		data.field = this.find(this.options.formElementsIdClassNames.dimensionAttribute + ' option:selected').text().trim();
		
		var datatype = this.find(this.options.formElementsIdClassNames.rangeType).val();
		var minMaxValues = {};
		
		switch(datatype) {
		
		case dataModelDetails.constants.INTEGER :
		    if( typeof self.find('.' + self.rangeDataTypesConainerClass).data('rdb-IntegerRangeConstraintEditor') !== "undefined" )
		        minMaxValues = self.find('.' + self.rangeDataTypesConainerClass).data('rdb-IntegerRangeConstraintEditor').getData();
		    else minMaxValues = self.find('.' + self.rangeDataTypesConainerClass).EditIntegerRangeConstraintEditor('getData');
		    break
		case dataModelDetails.constants.DECIMAL :
			minMaxValues = self.find('.' + self.rangeDataTypesConainerClass).EditIntegerRangeConstraintEditor('getData');
			break;
		case dataModelDetails.constants.DATE :
			minMaxValues = self.find('.' + self.rangeDataTypesConainerClass).EditDateRangeConstraintEditor('getData');
			break;
		default :
			alert("Not known datatype selected");
		
		};
		
//		for(var property in minMaxValues) {
//			data[property] = minMaxValues[property];
//		}
		Object.assign(data, minMaxValues);
		
		return data;
	},
	
	initDefaultRangeDataType : function() {
        this.options.decimal = null;
        this.options.integer = true;
		this.find('.' + this.rangeDataTypesConainerClass).IntegerRangeConstraintEditor(this.options);
	},
	
	initUIBindings : function() {
		var self = this;
		
		setTimeout(function() {
			self.fillDimensionAttributesDropdown();
		}, 300);
		
		this.find(this.options.formElementsIdClassNames.rangeType).off().on('change', function() {
//			console.log("type change occurred");
//			Destroy the widgets initialized on this element
			$.each(self.find('.' + self.rangeDataTypesConainerClass).data(), function(i, v) {
				if( typeof self.find('.' + self.rangeDataTypesConainerClass).data(i).destroy !== 'undefined' )
					typeof self.find('.' + self.rangeDataTypesConainerClass).data(i).destroy();
			});

			var $dropdown = self.find(self.options.formElementsIdClassNames.dimensionAttribute);
            let fieldId = $dropdown.val();

			var dataType = $(this).val();
			self.loadSubEditorsByRangeType(dataType, fieldId);
		});
	},
	
	initValidation : function() {
		
	},
	
	loadSubEditorsByRangeType : function(rangeType, fieldId) {
	    this.options.fieldId = fieldId;

		switch(rangeType) {
		
		case dataModelDetails.constants.INTEGER :
		    this.options.decimal = null;
		    this.options.integer = true;
			this.find('.' + this.rangeDataTypesConainerClass).EditIntegerRangeConstraintEditor(this.options);
			
			break;
		case dataModelDetails.constants.DECIMAL :
		    this.options.decimal = true;
		    this.options.integer = null;
			this.find('.' + this.rangeDataTypesConainerClass).EditIntegerRangeConstraintEditor(this.options);
			
			break;
		case dataModelDetails.constants.DATE :
			this.find('.' + this.rangeDataTypesConainerClass).EditDateRangeConstraintEditor(this.options);
			
			break;
		default :
			alert("Not known datatype option");
		}
		
	},
	
	rangeDataTypesConainerClass : 'edit-range-constraint-datatypes-container'
});