/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.validation;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.CatalogBsClient;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemNotFoundException;
import com.finconsgroup.itserr.marketplace.zenodo.bs.exception.SourceItemRetrieveException;
import feign.FeignException;
import lombok.Generated;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class CatalogItemValidator {
    private final CatalogBsClient catalogBsClient;

    @NonNull
    public OutputCatalogItemDto validate(String catalogItemId) {
        OutputCatalogItemDto item;
        try {
            item = this.catalogBsClient.getItemById(catalogItemId);
        }
        catch (FeignException.NotFound e) {
            throw new SourceItemNotFoundException();
        }
        catch (Exception e) {
            throw new SourceItemRetrieveException(e);
        }
        return item;
    }

    @Generated
    public CatalogItemValidator(CatalogBsClient catalogBsClient) {
        this.catalogBsClient = catalogBsClient;
    }
}

