package com.finconsgroup.itserr.marketplace.zenodo.bs.service.impl;

import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoConfigurationProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties.ZenodoOauthProperties;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.OutputZenodoConfigDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.mapper.ExportRequestMapper;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.zenodo.bs.service.ZenodoService;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CreateExportRequestValidator;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/**
 * Default implementation of the {@link ZenodoService} interface that provides Zenodo-related operations and configuration management functionality.
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultZenodoService implements ZenodoService {

    /** Configuration properties for Zenodo service containing OAuth and host settings */
    private final ZenodoConfigurationProperties zenodoConfigurationProperties;

    private final CreateExportRequestValidator createExportRequestValidator;

    private final ExportRequestMapper exportRequestMapper;

    private final EventProducer eventProducer;

    @Override
    public OutputZenodoConfigDto getConfig() {
        final ZenodoOauthProperties oauth = zenodoConfigurationProperties.getOauth();
        return OutputZenodoConfigDto.builder()
                .host(zenodoConfigurationProperties.getHost())
                .clientId(oauth.getClientId())
                .scopes(oauth.getScopes())
                .build();
    }

    @Override
    public void createExport(@NonNull final InputCreateZenodoExportDto request) {

        // Validate request
        final CreateExportRequestValidator.ValidatedRequest data = createExportRequestValidator.validate(request);

        // Send event
        eventProducer.publishExportRequestCreatedEvent(
                exportRequestMapper.toMessageDto(data));

    }

}
