package com.finconsgroup.itserr.marketplace.zenodo.bs.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ValidationException;

/**
 * Exception thrown when a source item ID is missing or not provided in the request. This runtime exception indicates that a required source identification was
 * not supplied during an operation that requires it.
 */
public class NoSourceItemIdException extends WP2ValidationException {

    /**
     * Constructs a new NoSourceItemIdException with a default error message.
     */
    public NoSourceItemIdException() {
        super("No source item id provided");
    }

}
