package com.finconsgroup.itserr.marketplace.zenodo.bs.controller;

import com.finconsgroup.itserr.marketplace.zenodo.bs.api.ZenodoApi;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.OutputZenodoConfigDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.service.ZenodoService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

/**
 * REST controller class for handling the Zenodo-related API requests.
 *
 * <p>Implements the {@link ZenodoApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ZenodoController implements ZenodoApi {

    /** Service dependency responsible for providing Zenodo-related operations. */
    private final ZenodoService zenodoService;

    @Override
    public OutputZenodoConfigDto getZenodoConfig() {
        return zenodoService.getConfig();
    }

    @Override
    public void createExport(final InputCreateZenodoExportDto request) {
        zenodoService.createExport(request);
    }

}
