package com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto;

import jakarta.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Data Transfer Object for OAuth token request parameters used in Zenodo authentication.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class InputOauthTokenRequestDto {

    /** The client identifier issued to the client during the registration process */
    @NotBlank
    private String client_id;

    /** The client secret issued to the client during the registration process */
    @NotBlank
    private String client_secret;

    /** The grant type of the OAuth 2.0 flow to be used */
    @NotBlank
    private String grant_type;

    /** The authorization code received from the authorization server */
    @NotBlank
    private String code;

    /** The redirect URI that was used in the initial authorization request */
    @NotBlank
    private String redirect_uri;

}
