package com.finconsgroup.itserr.marketplace.zenodo.bs.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;

/**
 * Exception thrown when there is an error retrieving a source item.
 */
public class SourceItemRetrieveException extends WP2BusinessException {

    /**
     * Constructs a new ErrorRetrievingSourceItemException with the specified cause.
     *
     * @param cause the underlying exception that caused the retrieval failure
     */
    public SourceItemRetrieveException(final Exception cause) {
        super("Error retrieving source item", cause);
    }

}
