package com.finconsgroup.itserr.marketplace.zenodo.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * Output DTO representing Zenodo configuration settings used for API integration. Contains information about the API host, OAuth client identifier, and
 * required authorization scopes.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputZenodoConfigDto {

    /**
     * The hostname of the Zenodo API endpoints.
     */
    @Schema(description = "The hostname of the Zenodo API endpoints.", example = "zenodo.org")
    private String host;

    /**
     * The OAuth client identifier used for authentication with the Zenodo API.
     */
    @Schema(description = "The OAuth client identifier used for authentication with the Zenodo API.", example = "1234567890")
    private String clientId;

    /**
     * The OAuth scopes defining the access permissions requested from Zenodo.
     */
    @Schema(description = "The OAuth scopes defining the access permissions requested from Zenodo.", example = "[\"deposit:write\"]")
    private List<String> scopes = new ArrayList<>();

}
