package com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

import java.util.ArrayList;
import java.util.List;

/**
 * Configuration properties class for Zenodo OAuth settings. Contains properties required for OAuth authentication with the Zenodo API.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Validated
public class ZenodoOauthProperties {

    /**
     * The OAuth client identifier used for authentication with the Zenodo API. This value must not be blank and is required to properly configure the
     * authentication process.
     */
    @NotBlank
    private String clientId;

    /**
     * The OAuth client secret used for authentication with the Zenodo API. This value must not be blank and is required to securely complete the OAuth
     * authentication process.
     */
    @NotBlank
    private String clientSecret;

    /**
     * The OAuth scopes defining the access permissions requested from Zenodo.
     */
    @NotNull
    @NotEmpty
    private List<String> scopes = new ArrayList<>();

}
