package com.finconsgroup.itserr.marketplace.zenodo.bs.config.properties;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Configuration properties class for Zenodo settings. This class contains properties required to configure interactions with the Zenodo API.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Validated
@ConfigurationProperties(prefix = "zenodo")
public class ZenodoConfigurationProperties {

    /**
     * The hostname of the Zenodo API endpoints. This property must not be blank.
     */
    @NotBlank
    private String host;

    /**
     * Configuration property for Zenodo OAuth settings. This property holds the configuration required to authenticate with the Zenodo API using OAuth.
     */
    @Valid
    @NotNull
    private ZenodoOauthProperties oauth;

}
