package com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Data Transfer Object (DTO) representing the OAuth token response from OAUTH authentication. Contains access token details, token type, expiration, refresh
 * token and scope information.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputOauthTokenDto {

    /** The OAuth access token used for authenticating requests */
    @JsonProperty("access_token")
    private String accessToken;

    /** The type of token, typically "Bearer" */
    @JsonProperty("token_type")
    private String tokenType;

    /** Time in seconds until the access token expires */
    @JsonProperty("expires_in")
    private Integer expiresIn;

    /** Token used to obtain a new access token when the current one expires */
    @JsonProperty("refresh_token")
    private String refreshToken;

    /** The scope of access granted by this token */
    @JsonProperty("scope")
    private String scope;

}
