package com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo;

import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.InputOauthTokenRequestDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.OutputOauthTokenDto;
import jakarta.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * Client interface for interacting with the Zenodo services.
 */
public interface ZenodoClient {

    /**
     * Gets an OAuth token from the Zenodo service.
     *
     * @param request the token request containing the necessary OAuth credentials
     * @return an OAuth token response containing the access token and related information
     */
    @NonNull
    @PostMapping(
            path = "/oauth/token",
            consumes = MediaType.APPLICATION_FORM_URLENCODED_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    OutputOauthTokenDto getToken(@Valid @RequestBody InputOauthTokenRequestDto request);

}
