package com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.validation.constraints.Email;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Data Transfer Object representing an author of a catalog item in the Zenodo system.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class CatalogItemAuthorDto {

    /** Author's first name */
    private String firstName;

    /** Author's last name */
    private String lastName;

    /** Author's email address */
    @Email
    private String email;

    /** Author's ORCID identifier */
    private String orcid;

}
