/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.zenodo.bs.mapper;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.catalog.dto.OutputCatalogItemDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.client.zenodo.dto.OutputOauthTokenDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.dto.InputCreateZenodoExportDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.mapper.ExportRequestMapper;
import com.finconsgroup.itserr.marketplace.zenodo.bs.messaging.dto.ExportRequestCreatedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.zenodo.bs.validation.CreateExportRequestValidator;
import java.time.Instant;
import org.springframework.stereotype.Component;

@Component
public class ExportRequestMapperImpl
implements ExportRequestMapper {
    public ExportRequestCreatedMessageBodyDto toMessageDto(CreateExportRequestValidator.ValidatedRequest src) {
        if (src == null) {
            return null;
        }
        ExportRequestCreatedMessageBodyDto.ExportRequestCreatedMessageBodyDtoBuilder exportRequestCreatedMessageBodyDto = ExportRequestCreatedMessageBodyDto.builder();
        exportRequestCreatedMessageBodyDto.id(this.srcRequestSourceId(src));
        exportRequestCreatedMessageBodyDto.title(this.srcCatalogItemTitle(src));
        exportRequestCreatedMessageBodyDto.user(this.getMessageUserFromSecurity());
        exportRequestCreatedMessageBodyDto.timestamp(Instant.now());
        exportRequestCreatedMessageBodyDto.additionalData((Object)this.toExportRequestCreateAdditionalDataDto(src));
        return exportRequestCreatedMessageBodyDto.build();
    }

    public ExportRequestCreatedMessageBodyDto.AdditionalData toExportRequestCreateAdditionalDataDto(CreateExportRequestValidator.ValidatedRequest src) {
        if (src == null) {
            return null;
        }
        ExportRequestCreatedMessageBodyDto.AdditionalData.AdditionalDataBuilder additionalData = ExportRequestCreatedMessageBodyDto.AdditionalData.builder();
        InputCreateZenodoExportDto.SourceType type = this.srcRequestSourceType(src);
        if (type != null) {
            additionalData.sourceType(type.name());
        }
        additionalData.zenodoJwtToken(this.srcZenodoTokenAccessToken(src));
        additionalData.zenodoJwtRefreshToken(this.srcZenodoTokenRefreshToken(src));
        additionalData.d4sJwtToken(JwtTokenHolder.getToken());
        return additionalData.build();
    }

    private String srcRequestSourceId(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        InputCreateZenodoExportDto request = validatedRequest.request();
        if (request == null) {
            return null;
        }
        InputCreateZenodoExportDto.SourceDto source = request.getSource();
        if (source == null) {
            return null;
        }
        return source.getId();
    }

    private String srcCatalogItemTitle(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputCatalogItemDto catalogItem = validatedRequest.catalogItem();
        if (catalogItem == null) {
            return null;
        }
        return catalogItem.getTitle();
    }

    private InputCreateZenodoExportDto.SourceType srcRequestSourceType(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        InputCreateZenodoExportDto request = validatedRequest.request();
        if (request == null) {
            return null;
        }
        InputCreateZenodoExportDto.SourceDto source = request.getSource();
        if (source == null) {
            return null;
        }
        return source.getType();
    }

    private String srcZenodoTokenAccessToken(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputOauthTokenDto zenodoToken = validatedRequest.zenodoToken();
        if (zenodoToken == null) {
            return null;
        }
        return zenodoToken.getAccessToken();
    }

    private String srcZenodoTokenRefreshToken(CreateExportRequestValidator.ValidatedRequest validatedRequest) {
        OutputOauthTokenDto zenodoToken = validatedRequest.zenodoToken();
        if (zenodoToken == null) {
            return null;
        }
        return zenodoToken.getRefreshToken();
    }
}

